/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;

public abstract class PageBtree
extends Page {
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageBtreeIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int[] offsets;
    protected int entryCount;
    protected SearchRow[] rows;
    protected int start;
    protected boolean onlyPosition;
    protected boolean written;

    PageBtree(PageBtreeIndex pageBtreeIndex, int n, Data data) {
        this.index = pageBtreeIndex;
        this.data = data;
        this.setPos(n);
    }

    abstract int getRowCount() throws SQLException;

    abstract void setRowCountStored(int var1) throws SQLException;

    int find(SearchRow searchRow, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (searchRow == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.entryCount;
        int n3 = 1;
        while (n < n2) {
            int n4 = n + n2 >>> 1;
            SearchRow searchRow2 = this.getRow(n4);
            n3 = this.index.compareRows(searchRow2, searchRow);
            if (n3 == 0) {
                if (bl2 && this.index.indexType.isUnique() && !this.index.containsNullAndAllowMultipleNull(searchRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                if (bl3 && (n3 = this.index.compareKeys(searchRow2, searchRow)) == 0) {
                    return n4;
                }
            }
            if (n3 > 0 || !bl && n3 == 0) {
                n2 = n4;
                continue;
            }
            n = n4 + 1;
        }
        return n;
    }

    abstract int addRowTry(SearchRow var1) throws SQLException;

    abstract void find(PageBtreeCursor var1, SearchRow var2, boolean var3) throws SQLException;

    abstract void last(PageBtreeCursor var1) throws SQLException;

    SearchRow getRow(int n) throws SQLException {
        SearchRow searchRow = this.rows[n];
        if (searchRow == null) {
            this.rows[n] = searchRow = this.index.readRow(this.data, this.offsets[n], this.onlyPosition);
        }
        return searchRow;
    }

    abstract PageBtree split(int var1) throws SQLException;

    void setPageId(int n) throws SQLException {
        this.written = false;
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n);
        this.remapChildren();
    }

    abstract PageBtreeLeaf getFirstLeaf() throws SQLException;

    abstract PageBtreeLeaf getLastLeaf() throws SQLException;

    void setParentPageId(int n) {
        this.written = false;
        this.parentPageId = n;
    }

    abstract void remapChildren() throws SQLException;

    abstract SearchRow remove(SearchRow var1) throws SQLException;

    abstract void freeChildren() throws SQLException;

    protected void readAllRows() throws SQLException {
        for (int i = 0; i < this.entryCount; ++i) {
            this.getRow(i);
        }
    }

    public int getMemorySize() {
        return this.index.getPageStore().getPageSize();
    }
}

