/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageIndex;
import org.h2.index.RowIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageDataIndex
extends PageIndex
implements RowIndex {
    private PageStore store;
    private TableData tableData;
    private long lastKey;
    private long rowCount;
    private HashSet<Row> delta;
    private int rowCountDiff;
    private HashMap<Integer, Integer> sessionRowCount;
    private int mainIndexColumn = -1;
    private SQLException fastDuplicateKeyException;
    private int memorySizePerPage;

    public PageDataIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, Session session) throws SQLException {
        PageData pageData;
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            this.sessionRowCount = New.hashMap();
            this.isMultiVersion = true;
        }
        this.tableData = tableData;
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (!this.database.isPersistent()) {
            throw Message.throwInternalError(tableData.getName());
        }
        if (n2 == -1) {
            this.rootPageId = this.store.allocatePage();
            this.store.addMeta(this, session);
            pageData = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.updateRecord(pageData, true, ((PageDataLeaf)pageData).data);
        } else {
            this.rootPageId = this.store.getRootPageId(n);
            pageData = this.getPage(this.rootPageId, 0);
            this.lastKey = pageData.getLastKey();
            this.rowCount = pageData.getRowCount();
            if (!this.database.isReadOnly()) {
                this.store.updateRecord(pageData, false, null);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
        tableData.setRowCount(this.rowCount);
        this.fastDuplicateKeyException = super.getDuplicateKeyException();
        this.memorySizePerPage = this.store.getPageSize();
        int n3 = this.store.getPageSize() / ((1 + indexColumnArray.length) * 8);
        this.memorySizePerPage += n3 * 64;
    }

    @Override
    public SQLException getDuplicateKeyException() {
        return this.fastDuplicateKeyException;
    }

    @Override
    public void add(Session session, Row row) throws SQLException {
        boolean bl = false;
        if (this.mainIndexColumn != -1) {
            row.setKey(row.getValue(this.mainIndexColumn).getLong());
        } else if (row.getKey() == 0L) {
            row.setKey((int)(++this.lastKey));
            bl = true;
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add table:" + this.table.getId() + " " + row);
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                Value value2 = value.link(this.database, this.getId());
                if (value2.isLinked()) {
                    session.unlinkAtCommitStop(value2);
                }
                if (value == value2) continue;
                row.setValue(i, value2);
            }
        }
        long l = 0L;
        while (true) {
            try {
                this.addTry(session, row);
            }
            catch (SQLException sQLException) {
                if (sQLException != this.fastDuplicateKeyException) {
                    throw sQLException;
                }
                if (!bl) {
                    throw super.getDuplicateKeyException();
                }
                if (l == 0L) {
                    row.setKey((long)((double)row.getKey() + Math.random() * 10000.0));
                } else {
                    row.setKey(row.getKey() + l);
                }
                ++l;
                continue;
            }
            break;
        }
        this.lastKey = Math.max(this.lastKey, row.getKey() + 1L);
    }

    private void addTry(Session session, Row row) throws SQLException {
        PageData pageData;
        int n;
        while ((n = (pageData = this.getPage(this.rootPageId, 0)).addRowTry(row)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            long l = n == 0 ? row.getKey() : pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n2 = pageData.getPos();
            int n3 = this.store.allocatePage();
            pageData2.setPageId(n3);
            pageData2.setParentPageId(n2);
            pageData3.setParentPageId(n2);
            PageDataNode pageDataNode = PageDataNode.create(this, n2, 0);
            pageDataNode.init(pageData2, l, pageData3);
            this.store.updateRecord(pageData2, true, pageData2.data);
            this.store.updateRecord(pageData3, true, pageData3.data);
            this.store.updateRecord(pageDataNode, true, null);
            pageData = pageDataNode;
        }
        row.setDeleted(false);
        if (this.database.isMultiVersion()) {
            boolean bl;
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(bl = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        this.invalidateRowCount();
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageDataOverflow getPageOverflow(int n) throws SQLException {
        return (PageDataOverflow)this.store.getPage(n);
    }

    PageData getPage(int n, int n2) throws SQLException {
        PageData pageData = (PageData)this.store.getPage(n);
        if (pageData == null) {
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, n, n2);
            return pageDataLeaf;
        }
        if (pageData.index.rootPageId != this.rootPageId) {
            throw Message.throwInternalError("Wrong index: " + pageData.index.getName() + ":" + pageData.index.rootPageId + " " + this.getName() + ":" + this.rootPageId);
        }
        if (n2 != -1 && pageData.getParentPageId() != n2) {
            throw Message.throwInternalError(pageData + " parent " + pageData.getParentPageId() + " expected " + n2);
        }
        return pageData;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    long getLong(SearchRow searchRow, long l) throws SQLException {
        if (searchRow == null) {
            return l;
        }
        Value value = searchRow.getValue(this.mainIndexColumn);
        if (value == null || value == ValueNull.INSTANCE) {
            return l;
        }
        return value.getLong();
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, Long.MIN_VALUE, Long.MAX_VALUE, this.isMultiVersion);
    }

    Cursor find(Session session, long l, long l2, boolean bl) throws SQLException {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, l, l2, bl);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw Message.throwInternalError();
    }

    long getLastKey() throws SQLException {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getLastKey();
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        long l = 10L * (this.tableData.getRowCountApproximation() + 1000L);
        return l;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) throws SQLException {
        int n;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getKey());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (n = 0; n < row.getColumnCount(); ++n) {
                Value value = row.getValue(n);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit((ValueLob)value);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            long l = row.getKey();
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.remove(l);
            this.invalidateRowCount();
            --this.rowCount;
        }
        if (this.database.isMultiVersion()) {
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if ((n = (int)(this.delta.remove(row) ? 1 : 0)) == 0) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    private void invalidateRowCount() throws SQLException {
        PageData pageData = this.getPage(this.rootPageId, 0);
        pageData.setRowCountStored(-1);
    }

    @Override
    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.removeAllRows();
        this.store.freePage(this.rootPageId, false, null);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.store.logTruncate(session, this.tableData.getId());
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        PageData pageData = this.getPage(this.rootPageId, 0);
        pageData.freeChildren();
        pageData = PageDataLeaf.create(this, this.rootPageId, 0);
        this.store.removeRecord(this.rootPageId);
        this.store.updateRecord(pageData, true, null);
        this.rowCount = 0L;
        this.lastKey = 0L;
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    @Override
    public Row getRow(Session session, long l) throws SQLException {
        return this.getRow(l);
    }

    public Row getRow(long l) throws SQLException {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getRow(l);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(Data data, int n) throws SQLException {
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = data.readValue();
        }
        return this.tableData.createRow(valueArray);
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer n = this.sessionRowCount.get(session.getId());
            long l = n == null ? 0L : (long)n.intValue();
            l += this.rowCount;
            return l -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public int getColumnIndex(Column column) {
        if (column.getColumnId() == this.mainIndexColumn) {
            return 0;
        }
        return -1;
    }

    @Override
    public void close(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
        if (this.delta != null) {
            this.delta.clear();
        }
        this.rowCountDiff = 0;
        if (this.sessionRowCount != null) {
            this.sessionRowCount.clear();
        }
        PageData pageData = this.getPage(this.rootPageId, 0);
        pageData.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.delta.iterator();
    }

    private void incrementRowCount(int n, int n2) {
        if (this.database.isMultiVersion()) {
            Integer n3 = n;
            Integer n4 = this.sessionRowCount.get(n3);
            int n5 = n4 == null ? 0 : n4;
            this.sessionRowCount.put(n3, n5 + n2);
            this.rowCountDiff += n2;
        }
    }

    @Override
    public void commit(int n, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), n == 1 ? 1 : -1);
        }
    }

    void setRootPageId(Session session, int n) throws SQLException {
        this.store.removeMeta(this, session);
        this.rootPageId = n;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    int getMemorySizePerPage() {
        return this.memorySizePerPage;
    }
}

