/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.state.impl;

import java.util.concurrent.TimeUnit;
import org.seasar.chronos.core.task.state.TaskExecuteContext;
import org.seasar.chronos.core.task.state.TaskExecuteState;
import org.seasar.chronos.core.task.state.impl.TaskExecuteStateFinished;
import org.seasar.chronos.core.task.state.impl.TaskExecuteStateInitialized;
import org.seasar.chronos.core.task.state.impl.TaskExecuteStateNonInitialized;
import org.seasar.chronos.core.task.state.impl.TaskExecuteStateStarted;
import org.seasar.chronos.core.task.strategy.TaskExecuteStrategy;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskExecuteContext
implements TaskExecuteContext {
    private TaskExecuteState currentState;
    private final TaskExecuteStrategy taskExecuteStrategy;
    private final TaskExecuteState taskExecuteStateInitialized;
    private final TaskExecuteState taskExecuteStateNonInitialized;
    private final TaskExecuteState taskExecuteStateStarted;
    private final TaskExecuteState taskExecuteStateFinished;

    public AbstractTaskExecuteContext(TaskExecuteStrategy taskExecuteStrategy) {
        this.taskExecuteStrategy = taskExecuteStrategy;
        this.taskExecuteStateInitialized = new TaskExecuteStateInitialized(taskExecuteStrategy);
        this.taskExecuteStateNonInitialized = new TaskExecuteStateNonInitialized(taskExecuteStrategy);
        this.taskExecuteStateStarted = new TaskExecuteStateStarted(taskExecuteStrategy);
        this.taskExecuteStateFinished = new TaskExecuteStateFinished(taskExecuteStrategy);
        this.currentState = this.taskExecuteStateNonInitialized;
    }

    @Override
    public boolean await(long time, TimeUnit timeUnit) throws InterruptedException {
        return this.currentState.await(this, time, timeUnit);
    }

    @Override
    public boolean cancel() {
        return this.currentState.cancel(this);
    }

    @Override
    public void changeState(TaskExecuteState nextState) {
        this.currentState = nextState;
    }

    @Override
    public String finish() throws InterruptedException {
        return this.currentState.finish(this);
    }

    @Override
    public void execute(String startTaskName) throws InterruptedException {
        this.currentState.execute(this, startTaskName);
    }

    public Object getTask() {
        return this.taskExecuteStrategy.getTask();
    }

    public Class<?> getTaskClass() {
        return this.taskExecuteStrategy.getTaskClass();
    }

    @Override
    public final TaskExecuteState getTaskExecuteStateInitialized() {
        return this.taskExecuteStateInitialized;
    }

    @Override
    public final TaskExecuteState getTaskExecuteStateNonInitialized() {
        return this.taskExecuteStateNonInitialized;
    }

    public final TaskExecuteState getTaskExecuteStateStarted() {
        return this.taskExecuteStateStarted;
    }

    public final TaskExecuteState getTaskExecuteStateFinished() {
        return this.taskExecuteStateFinished;
    }

    @Override
    public TaskExecuteStrategy getTaskExecuteStrategy() {
        return this.currentState.getTaskExecuteStrategy();
    }

    @Override
    public String start() throws InterruptedException {
        return this.currentState.start(this);
    }

    @Override
    @Binding(bindingType=BindingType.NONE)
    public void setGetterSignal(Object getterSignal) {
        this.taskExecuteStrategy.setGetterSignal(getterSignal);
    }

    public void setTask(Object task) {
        this.taskExecuteStrategy.setTask(task);
    }

    public void setTaskClass(Class<?> taskClass) {
        this.taskExecuteStrategy.setTaskClass(taskClass);
    }

    @Override
    public void waitOne() throws InterruptedException {
        this.currentState.waitOne();
    }

    @Override
    public void destroy() throws InterruptedException {
        this.currentState.destroy(this);
    }

    @Override
    public void initialize() throws InterruptedException {
        this.currentState.initialize(this);
    }
}

