/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.client.S2RobotClient;
import org.seasar.robot.client.S2RobotClientFactory;
import org.seasar.robot.client.fs.ChildUrlsException;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.processor.ResponseProcessor;
import org.seasar.robot.rule.Rule;
import org.seasar.robot.service.DataService;
import org.seasar.robot.service.UrlQueueService;
import org.seasar.robot.util.CrawlingParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2RobotThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(S2RobotThread.class);
    @Resource
    protected UrlQueueService urlQueueService;
    @Resource
    protected DataService dataService;
    @Resource
    protected S2Container container;
    protected S2RobotClientFactory clientFactory;
    protected S2RobotContext robotContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCrawling() {
        Object object = this.robotContext.activeThreadCountLock;
        synchronized (object) {
            S2RobotContext s2RobotContext = this.robotContext;
            Integer n = s2RobotContext.activeThreadCount;
            Integer n2 = s2RobotContext.activeThreadCount = Integer.valueOf(s2RobotContext.activeThreadCount + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishCrawling() {
        Object object = this.robotContext.activeThreadCountLock;
        synchronized (object) {
            S2RobotContext s2RobotContext = this.robotContext;
            Integer n = s2RobotContext.activeThreadCount;
            Integer n2 = s2RobotContext.activeThreadCount = Integer.valueOf(s2RobotContext.activeThreadCount - 1);
        }
    }

    protected boolean isContinue(int tcCount) {
        if (!SingletonS2ContainerFactory.hasContainer()) {
            return false;
        }
        boolean isContinue = false;
        if (tcCount < this.robotContext.maxThreadCheckCount) {
            if (this.robotContext.maxAccessCount > 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Access Count: " + this.robotContext.accessCount);
                }
                if (this.robotContext.accessCount >= this.robotContext.maxAccessCount) {
                    return false;
                }
            }
            isContinue = true;
        }
        if (!isContinue && this.robotContext.activeThreadCount > 0) {
            return true;
        }
        return isContinue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block53: {
            threadCheckCount = 0;
            CrawlingParameterUtil.setRobotContext(this.robotContext);
            CrawlingParameterUtil.setUrlQueueService(this.urlQueueService);
            CrawlingParameterUtil.setDataService(this.dataService);
            block35: while (true) {
                while (this.robotContext.running && this.isContinue(threadCheckCount)) {
                    urlQueue = this.urlQueueService.poll(this.robotContext.sessionId);
                    if (this.isValid(urlQueue)) {
                        responseData = null;
                        if (S2RobotThread.logger.isDebugEnabled()) {
                            S2RobotThread.logger.debug("Starting " + urlQueue.getUrl());
                        }
                        try {
                            client = this.getClient(urlQueue.getUrl());
                            if (client == null) {
                                if (S2RobotThread.logger.isInfoEnabled()) {
                                    S2RobotThread.logger.info("Unsupported URL: " + urlQueue.getUrl());
                                }
                                break block53;
                            }
                            this.startCrawling();
                            CrawlingParameterUtil.setUrlQueue(urlQueue);
                            if (this.robotContext.intervalController != null) {
                                this.robotContext.intervalController.delay(1);
                            }
                            if (S2RobotThread.logger.isInfoEnabled()) {
                                S2RobotThread.logger.info("Crawling URL: " + urlQueue.getUrl());
                            }
                            startTime = System.currentTimeMillis();
                            responseData = client.doGet(urlQueue.getUrl());
                            responseData.setExecutionTime(System.currentTimeMillis() - startTime);
                            responseData.setParentUrl(urlQueue.getParentUrl());
                            responseData.setSessionId(this.robotContext.sessionId);
                            if (responseData.getRedirectLocation() != null) {
                                var7_17 = this.robotContext.accessCountLock;
                                synchronized (var7_17) {
                                    this.storeChildUrl(responseData.getRedirectLocation(), urlQueue.getUrl(), urlQueue.getDepth() != null ? urlQueue.getDepth() + 1 : 1);
                                }
                            } else {
                                this.processResponse(urlQueue, responseData);
                            }
                            if (!S2RobotThread.logger.isDebugEnabled()) ** GOTO lbl88
                            S2RobotThread.logger.debug("Finished " + urlQueue.getUrl());
                        }
                        catch (ChildUrlsException e) {
                            var5_16 = this.robotContext.accessCountLock;
                            synchronized (var5_16) {
                                this.storeChildUrls(e.getChildUrlList(), urlQueue.getUrl(), urlQueue.getDepth() != null ? urlQueue.getDepth() + 1 : 1);
                            }
                        }
                        catch (RobotCrawlAccessException e) {
                            if (e.isDebugEnabled()) {
                                S2RobotThread.logger.debug("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
                            }
                            if (e.isInfoEnabled()) {
                                S2RobotThread.logger.info(e.getMessage());
                            }
                            if (e.isWarnEnabled()) {
                                S2RobotThread.logger.warn("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
                            }
                            if (!e.isErrorEnabled()) ** GOTO lbl88
                            S2RobotThread.logger.error("Crawling Access Exception at " + urlQueue.getUrl(), (Throwable)e);
                        }
                        catch (Exception e) {
                            S2RobotThread.logger.error("Crawling Exception at " + urlQueue.getUrl(), (Throwable)e);
                        }
                        finally {
                            if (responseData != null) {
                                IOUtils.closeQuietly((InputStream)responseData.getResponseBody());
                            }
                            if (this.robotContext.intervalController != null) {
                                try {
                                    this.robotContext.intervalController.delay(2);
                                }
                                catch (Exception e) {
                                    S2RobotThread.logger.warn("Could not sleep a thread: " + Thread.currentThread().getName(), (Throwable)e);
                                }
                            }
                            threadCheckCount = 0;
                            CrawlingParameterUtil.setUrlQueue(null);
                            this.finishCrawling();
                        }
                    } else {
                        if (S2RobotThread.logger.isDebugEnabled()) {
                            S2RobotThread.logger.debug("No url in a queue. (" + threadCheckCount + ")");
                        }
                        if (this.robotContext.intervalController != null) {
                            try {
                                this.robotContext.intervalController.delay(4);
                            }
                            catch (Exception e) {
                                S2RobotThread.logger.warn("Could not sleep a thread: " + Thread.currentThread().getName(), (Throwable)e);
                            }
                        }
                        ++threadCheckCount;
                    }
lbl88:
                    // 10 sources

                    if (this.robotContext.intervalController == null) continue;
                    try {
                        this.robotContext.intervalController.delay(8);
                        continue block35;
                    }
                    catch (Exception e) {
                        S2RobotThread.logger.warn("Could not sleep a thread: " + Thread.currentThread().getName(), (Throwable)e);
                    }
                }
                break block53;
                {
                    continue block35;
                    break;
                }
                break;
            }
            finally {
                CrawlingParameterUtil.setRobotContext(null);
                CrawlingParameterUtil.setUrlQueueService(null);
                CrawlingParameterUtil.setDataService(null);
            }
        }
    }

    protected S2RobotClient getClient(String url) {
        return this.clientFactory.getClient(url);
    }

    protected void processResponse(UrlQueue urlQueue, ResponseData responseData) {
        Rule rule = this.robotContext.ruleManager.getRule(responseData);
        if (rule != null) {
            responseData.setRuleId(rule.getRuleId());
            ResponseProcessor responseProcessor = rule.getResponseProcessor();
            if (responseProcessor != null) {
                responseProcessor.process(responseData);
            } else if (logger.isDebugEnabled()) {
                logger.debug("No ResponseProcessor for (" + responseData.getUrl() + ", " + responseData.getMimeType() + "). PLEASE CHECK YOUR CONFIGURATION.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("No rule for (" + responseData.getUrl() + ", " + responseData.getMimeType() + "). PLEASE CHECK YOUR CONFIGURATION.");
        }
    }

    private void storeChildUrls(Set<String> childUrlList, String url, int depth) {
        ArrayList<UrlQueue> childList = new ArrayList<UrlQueue>();
        for (String childUrl : childUrlList) {
            if (!this.robotContext.urlFilter.match(childUrl)) continue;
            UrlQueue uq = (UrlQueue)this.container.getComponent(UrlQueue.class);
            uq.setCreateTime(new Timestamp(new Date().getTime()));
            uq.setDepth(depth);
            uq.setMethod("GET");
            uq.setParentUrl(url);
            uq.setSessionId(this.robotContext.sessionId);
            uq.setUrl(childUrl);
            childList.add(uq);
        }
        this.urlQueueService.offerAll(this.robotContext.sessionId, childList);
    }

    private void storeChildUrl(String childUrl, String url, int depth) {
        if (this.robotContext.urlFilter.match(childUrl)) {
            ArrayList<UrlQueue> childList = new ArrayList<UrlQueue>(1);
            UrlQueue uq = (UrlQueue)this.container.getComponent(UrlQueue.class);
            uq.setCreateTime(new Timestamp(new Date().getTime()));
            uq.setDepth(depth);
            uq.setMethod("GET");
            uq.setParentUrl(url);
            uq.setSessionId(this.robotContext.sessionId);
            uq.setUrl(childUrl);
            childList.add(uq);
            this.urlQueueService.offerAll(this.robotContext.sessionId, childList);
        }
    }

    protected boolean isValid(UrlQueue urlQueue) {
        if (urlQueue == null) {
            return false;
        }
        if (StringUtil.isBlank((String)urlQueue.getUrl())) {
            return false;
        }
        if (this.robotContext.getMaxDepth() >= 0 && urlQueue.getDepth() > this.robotContext.getMaxDepth()) {
            return false;
        }
        return this.robotContext.urlFilter.match(urlQueue.getUrl());
    }
}

