/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlEntityProcessor
extends EntityProcessorBase {
    private static final Logger LOG = Logger.getLogger(SqlEntityProcessor.class.getName());
    protected DataSource<Iterator<Map<String, Object>>> dataSource;
    private static Pattern SELECT_WHERE_PATTERN = Pattern.compile("^\\s*(select\\b.*?\\b)(where).*", 2);
    public static final String QUERY = "query";
    public static final String DELTA_QUERY = "deltaQuery";
    public static final String PARENT_DELTA_QUERY = "parentDeltaQuery";
    public static final String DEL_PK_QUERY = "deletedPkQuery";
    public static final Pattern DOT_PATTERN = Pattern.compile(".*?\\.(.*)$");

    @Override
    public void init(Context context) {
        super.init(context);
        this.dataSource = context.getDataSource();
    }

    protected void initQuery(String q) {
        try {
            DataImporter.QUERY_COUNT.get().incrementAndGet();
            this.rowIterator = this.dataSource.getData(q);
            this.query = q;
        }
        catch (DataImportHandlerException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "The query failed '" + q + "'", e);
            throw new DataImportHandlerException(500, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        Map<String, Object> r;
        if (this.rowcache != null) {
            return this.getFromRowCache();
        }
        if (this.rowIterator == null) {
            String q = this.getQuery();
            this.initQuery(this.resolver.replaceTokens(q));
        }
        do {
            if ((r = this.getNext()) != null) continue;
            return null;
        } while ((r = this.applyTransformer(r)) == null);
        return r;
    }

    @Override
    public Map<String, Object> nextModifiedRowKey() {
        if (this.rowIterator == null) {
            String deltaQuery = this.context.getEntityAttribute(DELTA_QUERY);
            if (deltaQuery == null) {
                return null;
            }
            this.initQuery(this.resolver.replaceTokens(deltaQuery));
        }
        return this.getNext();
    }

    @Override
    public Map<String, Object> nextDeletedRowKey() {
        if (this.rowIterator == null) {
            String deletedPkQuery = this.context.getEntityAttribute(DEL_PK_QUERY);
            if (deletedPkQuery == null) {
                return null;
            }
            this.initQuery(this.resolver.replaceTokens(deletedPkQuery));
        }
        return this.getNext();
    }

    @Override
    public Map<String, Object> nextModifiedParentRowKey() {
        if (this.rowIterator == null) {
            String parentDeltaQuery = this.context.getEntityAttribute(PARENT_DELTA_QUERY);
            if (parentDeltaQuery == null) {
                return null;
            }
            LOG.info("Running parentDeltaQuery for Entity: " + this.context.getEntityAttribute("name"));
            this.initQuery(this.resolver.replaceTokens(parentDeltaQuery));
        }
        return this.getNext();
    }

    public String getQuery() {
        String queryString = this.context.getEntityAttribute(QUERY);
        if (this.context.currentProcess() == 1 || !this.context.isRootEntity()) {
            return queryString;
        }
        return this.getDeltaImportQuery(queryString);
    }

    public String getDeltaImportQuery(String queryString) {
        String[] primaryKeys;
        StringBuffer sb = new StringBuffer(queryString);
        if (SELECT_WHERE_PATTERN.matcher(queryString).find()) {
            sb.append(" and ");
        } else {
            sb.append(" where ");
        }
        boolean first = true;
        for (String primaryKey : primaryKeys = this.context.getEntityAttribute("pk").split(",")) {
            Matcher m;
            if (!first) {
                sb.append(" and ");
            }
            first = false;
            Object val = this.resolver.resolve("dataimporter.delta." + primaryKey);
            if (val == null && (m = DOT_PATTERN.matcher(primaryKey)).find()) {
                val = this.resolver.resolve("dataimporter.delta." + m.group(1));
            }
            sb.append(primaryKey).append(" = ");
            if (val instanceof Number) {
                sb.append(val.toString());
                continue;
            }
            sb.append("'").append(val.toString()).append("'");
        }
        return sb.toString();
    }
}

