/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.TemplateString;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateTransformer
extends Transformer {
    private static final Logger LOG = Logger.getLogger(TemplateTransformer.class.getName());
    public static final String TEMPLATE = "template";

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        String entityName = context.getEntityAttribute("name");
        VariableResolverImpl resolver = (VariableResolverImpl)context.getVariableResolver();
        Map resolverMap = (Map)resolver.resolve(entityName);
        HashMap<String, Object> resolverMapCopy = new HashMap<String, Object>();
        if (resolverMap != null) {
            for (Map.Entry<Object, Object> entry : resolverMap.entrySet()) {
                resolverMapCopy.put((String)entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : row.entrySet()) {
            resolverMapCopy.put((String)entry.getKey(), entry.getValue());
        }
        resolver.addNamespace(entityName, resolverMapCopy);
        for (Map map : context.getAllEntityFields()) {
            String expr = (String)map.get(TEMPLATE);
            if (expr == null) continue;
            String column = (String)map.get("column");
            boolean resolvable = true;
            List<String> variables = TemplateString.getVariables(expr);
            for (String v : variables) {
                if (resolver.resolve(v) != null) continue;
                LOG.warning("Unable to resolve variable: " + v + " while parsing expression: " + expr);
                resolvable = false;
            }
            if (!resolvable) continue;
            row.put(column, resolver.replaceTokens(expr));
        }
        resolver.addNamespace(entityName, resolverMap);
        return row;
    }
}

