/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathRecordReader {
    private Node rootNode = new Node("/", null);
    static XMLInputFactory factory = XMLInputFactory.newInstance();
    private static final Pattern ATTRIB_PRESENT_WITHVAL = Pattern.compile("(\\S*?)?(\\[@)(\\S*?)(='(.*?)')?(\\])");

    public XPathRecordReader(String forEachXpath) {
        String[] splits;
        for (String split : splits = forEachXpath.split("\\|")) {
            if ((split = split.trim()).length() == 0) continue;
            this.addField0(split, split, false, true);
        }
    }

    public synchronized XPathRecordReader addField(String name, String xpath, boolean multiValued) {
        if (!xpath.startsWith("/")) {
            throw new RuntimeException("xpath must start with '/' : " + xpath);
        }
        this.addField0(xpath, name, multiValued, false);
        return this;
    }

    private void addField0(String xpath, String name, boolean multiValued, boolean isRecord) {
        LinkedList<String> paths = new LinkedList<String>(Arrays.asList(xpath.split("/")));
        if ("".equals(((String)paths.get(0)).trim())) {
            paths.remove(0);
        }
        this.rootNode.build(paths, name, multiValued, isRecord);
    }

    public List<Map<String, Object>> getAllRecords(Reader r) {
        final ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        this.streamRecords(r, new Handler(){

            @Override
            public void handle(Map<String, Object> record, String s) {
                results.add(record);
            }
        });
        return results;
    }

    public void streamRecords(Reader r, Handler handler) {
        try {
            XMLStreamReader parser = factory.createXMLStreamReader(r);
            this.rootNode.parse(parser, handler, new HashMap(), new Stack(), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handler {
        public void handle(Map<String, Object> var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        String name;
        String fieldName;
        String xpathName;
        String forEachPath;
        List<Node> attributes;
        List<Node> childNodes;
        List<Map.Entry<String, String>> attribAndValues;
        Node parent;
        boolean hasText = false;
        boolean multiValued = false;
        boolean isRecord = false;

        public Node(String name, Node p) {
            this.xpathName = this.name = name;
            this.parent = p;
        }

        public Node(String name, String fieldName, boolean multiValued) {
            this.name = name;
            this.fieldName = fieldName;
            this.multiValued = multiValued;
        }

        private void parse(XMLStreamReader parser, Handler handler, Map<String, Object> values, Stack<Set<String>> stack, boolean recordStarted) throws IOException, XMLStreamException {
            Set<Object> valuesAddedinThisFrame = null;
            if (this.isRecord) {
                recordStarted = true;
                valuesAddedinThisFrame = new HashSet();
                stack.push(valuesAddedinThisFrame);
            } else if (recordStarted) {
                valuesAddedinThisFrame = stack.peek();
            } else {
                if (this.attributes != null || this.hasText) {
                    valuesAddedinThisFrame = new HashSet();
                }
                stack.push(valuesAddedinThisFrame);
            }
            try {
                if (this.attributes != null) {
                    for (Node node : this.attributes) {
                        String value = parser.getAttributeValue(null, node.name);
                        if (value == null && (!recordStarted || this.isRecord)) continue;
                        this.putText(values, value, node.fieldName, node.multiValued);
                        valuesAddedinThisFrame.add(node.fieldName);
                    }
                }
                HashSet<Node> childrenFound = new HashSet<Node>();
                boolean skipNextEvent = false;
                int event = -1;
                while (true) {
                    if (!skipNextEvent) {
                        event = parser.next();
                        skipNextEvent = false;
                    }
                    if (event == 8) {
                        return;
                    }
                    if (event == 2) {
                        if (this.isRecord) {
                            handler.handle(new HashMap<String, Object>(values), this.forEachPath);
                        }
                        if (recordStarted && !this.isRecord && !childrenFound.containsAll(this.childNodes)) {
                            for (Node n : this.childNodes) {
                                if (childrenFound.contains(n)) continue;
                                n.putNulls(values);
                            }
                        }
                        return;
                    }
                    if ((event == 12 || event == 4 || event == 6) && this.hasText) {
                        valuesAddedinThisFrame.add(this.fieldName);
                        skipNextEvent = true;
                        String text = parser.getText();
                        event = parser.next();
                        while (event == 12 || event == 4 || event == 6) {
                            text = text + parser.getText();
                            event = parser.next();
                        }
                        this.putText(values, text, this.fieldName, this.multiValued);
                        continue;
                    }
                    if (event != 1) continue;
                    Node n = this.getMatchingChild(parser);
                    if (n != null) {
                        childrenFound.add(n);
                        n.parse(parser, handler, values, stack, recordStarted);
                        continue;
                    }
                    this.skipTag(parser);
                }
            }
            finally {
                Set<String> cleanThis = null;
                if (!this.isRecord && recordStarted) {
                    return;
                }
                cleanThis = stack.pop();
                if (cleanThis != null) {
                    for (String fld : cleanThis) {
                        values.remove(fld);
                    }
                }
            }
        }

        private Node getMatchingChild(XMLStreamReader parser) {
            if (this.childNodes == null) {
                return null;
            }
            String localName = parser.getLocalName();
            for (Node n : this.childNodes) {
                if (!n.name.equals(localName)) continue;
                if (n.attribAndValues == null) {
                    return n;
                }
                if (!this.checkForAttributes(parser, n.attribAndValues)) continue;
                return n;
            }
            return null;
        }

        private boolean checkForAttributes(XMLStreamReader parser, List<Map.Entry<String, String>> attrs) {
            for (Map.Entry<String, String> e : attrs) {
                String val = parser.getAttributeValue(null, e.getKey());
                if (val == null) {
                    return false;
                }
                if (e.getValue() == null || e.getValue().equals(val)) continue;
                return false;
            }
            return true;
        }

        private void putNulls(Map<String, Object> values) {
            if (this.attributes != null) {
                for (Node n : this.attributes) {
                    if (!n.multiValued) continue;
                    this.putText(values, null, n.fieldName, true);
                }
            }
            if (this.hasText && this.multiValued) {
                this.putText(values, null, this.fieldName, true);
            }
            if (this.childNodes != null) {
                for (Node childNode : this.childNodes) {
                    childNode.putNulls(values);
                }
            }
        }

        private void putText(Map<String, Object> values, String value, String fieldName, boolean multiValued) {
            if (multiValued) {
                ArrayList<String> v = (ArrayList<String>)values.get(fieldName);
                if (v == null) {
                    v = new ArrayList<String>();
                    values.put(fieldName, v);
                }
                v.add(value);
            } else {
                values.put(fieldName, value);
            }
        }

        private void skipTag(XMLStreamReader parser) throws IOException, XMLStreamException {
            int type;
            while ((type = parser.next()) != 2) {
                if (type != 1) continue;
                this.skipTag(parser);
            }
        }

        public void build(List<String> paths, String fieldName, boolean multiValued, boolean record) {
            String name = paths.remove(0);
            if (paths.isEmpty() && name.startsWith("@")) {
                if (this.attributes == null) {
                    this.attributes = new ArrayList<Node>();
                }
                name = name.substring(1);
                this.attributes.add(new Node(name, fieldName, multiValued));
            } else {
                if (this.childNodes == null) {
                    this.childNodes = new ArrayList<Node>();
                }
                Node n = this.getOrAddChildNode(name);
                if (paths.isEmpty()) {
                    if (record) {
                        n.isRecord = true;
                        n.forEachPath = fieldName;
                    } else {
                        n.hasText = true;
                        n.fieldName = fieldName;
                        n.multiValued = multiValued;
                    }
                } else {
                    n.build(paths, fieldName, multiValued, record);
                }
            }
        }

        private Node getOrAddChildNode(String xpathName) {
            for (Node n : this.childNodes) {
                if (!n.xpathName.equals(xpathName)) continue;
                return n;
            }
            Node n = new Node(xpathName, this);
            Matcher m = ATTRIB_PRESENT_WITHVAL.matcher(xpathName);
            if (m.find()) {
                n.name = m.group(1);
                int start = m.start(2);
                while (true) {
                    HashMap<String, String> attribs = new HashMap<String, String>();
                    if (!m.find(start)) break;
                    attribs.put(m.group(3), m.group(5));
                    start = m.end(6);
                    if (n.attribAndValues == null) {
                        n.attribAndValues = new ArrayList<Map.Entry<String, String>>();
                    }
                    n.attribAndValues.addAll(attribs.entrySet());
                }
            }
            this.childNodes.add(n);
            return n;
        }
    }
}

