/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mobylet.core.Carrier;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.config.xml.MobyletConfigXmlReader;
import org.mobylet.core.detector.CarrierDetector;
import org.mobylet.core.dialect.MobyletDialect;
import org.mobylet.core.http.MobyletRequest;
import org.mobylet.core.http.MobyletResponse;
import org.mobylet.core.initializer.MobyletInitializer;
import org.mobylet.core.selector.DialectSelector;
import org.mobylet.core.type.DispatchType;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;

public class MobyletFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
        HttpServletResponse httpResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
        HttpServletRequest parentRequest = RequestUtils.get();
        RequestUtils.set(httpRequest);
        boolean isRootInclude = false;
        if (parentRequest != null && RequestUtils.getMobyletContext().get(DispatchType.class) == null) {
            RequestUtils.getMobyletContext().set((Object)DispatchType.INCLUDE_OR_FORWARD);
            isRootInclude = true;
        }
        try {
            this.processFilter(chain, httpRequest, httpResponse);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            RequestUtils.remove();
            if (parentRequest != null) {
                RequestUtils.set(parentRequest);
                if (isRootInclude) {
                    RequestUtils.getMobyletContext().remove(DispatchType.class);
                }
            }
        }
    }

    protected void processFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, IOException, ServletException {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        Carrier carrier = SingletonUtils.get(CarrierDetector.class).getCarrier((HttpServletRequest)request);
        MobyletDialect dialect = SingletonUtils.get(DialectSelector.class).getDialect(carrier);
        String charsetName = dialect.getCharacterEncodingCharsetName();
        request.setCharacterEncoding(charsetName);
        if (carrier != Carrier.OTHER) {
            request = new MobyletRequest((HttpServletRequest)request);
            ((MobyletRequest)((Object)MobyletRequest.class.cast(request))).parseParameters();
        }
        if (config.containsThroughCarrier(carrier)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            MobyletResponse mResponse = new MobyletResponse(response, dialect);
            if (RequestUtils.getMobyletContext().get(MobyletResponse.class) == null) {
                RequestUtils.getMobyletContext().set((Object)mResponse);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)mResponse);
            mResponse.flush();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initSingletonContainer(filterConfig);
        this.initDefaultCharset(filterConfig);
        this.initInitializer(filterConfig);
    }

    protected void initSingletonContainer(FilterConfig filterConfig) {
        if (!SingletonUtils.isInitialized()) {
            SingletonUtils.initialize(null);
        }
        if (filterConfig != null) {
            SingletonUtils.put(filterConfig);
            SingletonUtils.put(filterConfig.getServletContext());
        }
    }

    protected void initInitializer(FilterConfig filterConfig) {
        String configDir = "";
        if (filterConfig != null && (configDir = filterConfig.getInitParameter("mobylet.config.dir")) == null) {
            configDir = "";
        }
        MobyletConfigXmlReader configXml = new MobyletConfigXmlReader(configDir);
        MobyletConfig config = configXml.getConfig();
        for (MobyletInitializer initializer : config.getInitializers()) {
            initializer.initialize();
            SingletonUtils.put(initializer);
        }
    }

    protected void initDefaultCharset(FilterConfig filterConfig) {
        Charset defCharset;
        String defCharsetName = null;
        if (filterConfig != null && (defCharsetName = filterConfig.getInitParameter("encoding")) != null && (defCharset = Charset.forName(defCharsetName)) != null) {
            SingletonUtils.put(defCharset);
        }
        if (SingletonUtils.get(Charset.class) == null) {
            SingletonUtils.put(Charset.forName("windows-31j"));
        }
    }
}

