/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentMerger {
    static final byte[] NORMS_HEADER;
    private Directory directory;
    private String segment;
    private int termIndexInterval = 128;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private int mergedDocs;
    private CheckAbort checkAbort;
    private boolean mergeDocStores;
    private static final int MAX_RAW_MERGE_DOCS = 4192;
    private SegmentReader[] matchingSegmentReaders;
    private int[] rawDocLengths;
    private int[] rawDocLengths2;
    private IndexOutput freqOutput = null;
    private IndexOutput proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private int skipInterval;
    private int maxSkipLevels;
    private SegmentMergeQueue queue = null;
    private DefaultSkipListWriter skipListWriter = null;
    private final TermInfo termInfo = new TermInfo();
    private byte[] payloadBuffer;
    private int[][] docMaps;
    private int[] delCounts;
    static final /* synthetic */ boolean $assertionsDisabled;

    SegmentMerger(Directory dir, String name) {
        this.directory = dir;
        this.segment = name;
    }

    SegmentMerger(IndexWriter writer, String name, MergePolicy.OneMerge merge) {
        this.directory = writer.getDirectory();
        this.segment = name;
        if (merge != null) {
            this.checkAbort = new CheckAbort(merge, this.directory);
        }
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    boolean hasProx() {
        return this.fieldInfos.hasProx();
    }

    final void add(IndexReader reader) {
        this.readers.addElement(reader);
    }

    final IndexReader segmentReader(int i) {
        return (IndexReader)this.readers.elementAt(i);
    }

    final int merge() throws CorruptIndexException, IOException {
        return this.merge(true);
    }

    final int merge(boolean mergeDocStores) throws CorruptIndexException, IOException {
        this.mergeDocStores = mergeDocStores;
        this.mergedDocs = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (mergeDocStores && this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        return this.mergedDocs;
    }

    final void closeReaders() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            reader.close();
        }
    }

    final Vector createCompoundFile(String fileName) throws IOException {
        int i;
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, fileName, this.checkAbort);
        Vector<String> files = new Vector<String>(IndexFileNames.COMPOUND_EXTENSIONS.length + 1);
        for (i = 0; i < IndexFileNames.COMPOUND_EXTENSIONS.length; ++i) {
            String ext = IndexFileNames.COMPOUND_EXTENSIONS[i];
            if (ext.equals("prx") && !this.hasProx() || !this.mergeDocStores && (ext.equals("fdt") || ext.equals("fdx"))) continue;
            files.add(this.segment + "." + ext);
        }
        for (i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            files.add(this.segment + "." + "nrm");
            break;
        }
        if (this.fieldInfos.hasVectors() && this.mergeDocStores) {
            for (i = 0; i < IndexFileNames.VECTOR_EXTENSIONS.length; ++i) {
                files.add(this.segment + "." + IndexFileNames.VECTOR_EXTENSIONS[i]);
            }
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
        return files;
    }

    private void addIndexed(IndexReader reader, FieldInfos fieldInfos, Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean storePayloads, boolean omitTf) throws IOException {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String field;
            fieldInfos.add(field, true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector, !reader.hasNorms(field = (String)i.next()), storePayloads, omitTf);
        }
    }

    private void setMatchingSegmentReaders() {
        this.matchingSegmentReaders = new SegmentReader[this.readers.size()];
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            if (!(reader instanceof SegmentReader)) continue;
            SegmentReader segmentReader = (SegmentReader)reader;
            boolean same = true;
            FieldInfos segmentFieldInfos = segmentReader.getFieldInfos();
            for (int j = 0; same && j < segmentFieldInfos.size(); ++j) {
                same = this.fieldInfos.fieldName(j).equals(segmentFieldInfos.fieldName(j));
            }
            if (!same) continue;
            this.matchingSegmentReaders[i] = segmentReader;
        }
        this.rawDocLengths = new int[4192];
        this.rawDocLengths2 = new int[4192];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws CorruptIndexException, IOException {
        if (!this.mergeDocStores) {
            SegmentReader sr = (SegmentReader)this.readers.elementAt(this.readers.size() - 1);
            this.fieldInfos = (FieldInfos)sr.fieldInfos.clone();
        } else {
            this.fieldInfos = new FieldInfos();
        }
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            if (reader instanceof SegmentReader) {
                SegmentReader segmentReader = (SegmentReader)reader;
                for (int j = 0; j < segmentReader.getFieldInfos().size(); ++j) {
                    FieldInfo fi = segmentReader.getFieldInfos().fieldInfo(j);
                    this.fieldInfos.add(fi.name, fi.isIndexed, fi.storeTermVector, fi.storePositionWithTermVector, fi.storeOffsetWithTermVector, !reader.hasNorms(fi.name), fi.storePayloads, fi.omitTf);
                }
                continue;
            }
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET), true, true, true, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION), true, true, false, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET), true, false, true, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR), true, false, false, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.OMIT_TF), false, false, false, false, true);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.STORES_PAYLOADS), false, false, false, true, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.INDEXED), false, false, false, false, false);
            this.fieldInfos.add(reader.getFieldNames(IndexReader.FieldOption.UNINDEXED), false);
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        int docCount = 0;
        this.setMatchingSegmentReaders();
        if (this.mergeDocStores) {
            FieldSelector fieldSelectorMerge = new FieldSelector(){

                public FieldSelectorResult accept(String fieldName) {
                    return FieldSelectorResult.LOAD_FOR_MERGE;
                }
            };
            FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
            try {
                for (int i = 0; i < this.readers.size(); ++i) {
                    boolean hasMatchingReader;
                    FieldsReader matchingFieldsReader;
                    IndexReader reader = (IndexReader)this.readers.elementAt(i);
                    SegmentReader matchingSegmentReader = this.matchingSegmentReaders[i];
                    if (matchingSegmentReader != null) {
                        FieldsReader fieldsReader = matchingSegmentReader.getFieldsReader();
                        if (fieldsReader != null && !fieldsReader.canReadRawDocs()) {
                            matchingFieldsReader = null;
                            hasMatchingReader = false;
                        } else {
                            matchingFieldsReader = fieldsReader;
                            hasMatchingReader = true;
                        }
                    } else {
                        hasMatchingReader = false;
                        matchingFieldsReader = null;
                    }
                    int maxDoc = reader.maxDoc();
                    boolean hasDeletions = reader.hasDeletions();
                    int j = 0;
                    while (j < maxDoc) {
                        if (!hasDeletions || !reader.isDeleted(j)) {
                            if (hasMatchingReader) {
                                int start = j;
                                int numDocs = 0;
                                do {
                                    ++numDocs;
                                    if (++j >= maxDoc) break;
                                    if (!hasDeletions || !matchingSegmentReader.isDeleted(j)) continue;
                                    ++j;
                                    break;
                                } while (numDocs < 4192);
                                IndexInput stream = matchingFieldsReader.rawDocs(this.rawDocLengths, start, numDocs);
                                fieldsWriter.addRawDocuments(stream, this.rawDocLengths, numDocs);
                                docCount += numDocs;
                                if (this.checkAbort == null) continue;
                                this.checkAbort.work(300 * numDocs);
                                continue;
                            }
                            Document doc = reader.document(j, fieldSelectorMerge);
                            fieldsWriter.addDocument(doc);
                            ++j;
                            ++docCount;
                            if (this.checkAbort == null) continue;
                            this.checkAbort.work(300.0);
                            continue;
                        }
                        ++j;
                    }
                }
            }
            finally {
                fieldsWriter.close();
            }
            long fdxFileLength = this.directory.fileLength(this.segment + "." + "fdx");
            if ((long)(4 + docCount * 8) != fdxFileLength) {
                throw new RuntimeException("mergeFields produced an invalid result: docCount is " + docCount + " but fdx file size is " + fdxFileLength + "; now aborting this merge to prevent index corruption");
            }
        } else {
            for (int i = 0; i < this.readers.size(); ++i) {
                docCount += ((IndexReader)this.readers.elementAt(i)).numDocs();
            }
        }
        return docCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectors() throws IOException {
        TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            for (int r = 0; r < this.readers.size(); ++r) {
                boolean hasMatchingReader;
                TermVectorsReader matchingVectorsReader;
                SegmentReader matchingSegmentReader = this.matchingSegmentReaders[r];
                if (matchingSegmentReader != null) {
                    matchingVectorsReader = matchingSegmentReader.termVectorsReaderOrig;
                    if (matchingVectorsReader != null && !matchingVectorsReader.canReadRawDocs()) {
                        matchingVectorsReader = null;
                        hasMatchingReader = false;
                    } else {
                        hasMatchingReader = matchingVectorsReader != null;
                    }
                } else {
                    hasMatchingReader = false;
                    matchingVectorsReader = null;
                }
                IndexReader reader = (IndexReader)this.readers.elementAt(r);
                boolean hasDeletions = reader.hasDeletions();
                int maxDoc = reader.maxDoc();
                int docNum = 0;
                while (docNum < maxDoc) {
                    if (!hasDeletions || !reader.isDeleted(docNum)) {
                        if (hasMatchingReader) {
                            int start = docNum;
                            int numDocs = 0;
                            do {
                                ++numDocs;
                                if (++docNum >= maxDoc) break;
                                if (!hasDeletions || !matchingSegmentReader.isDeleted(docNum)) continue;
                                ++docNum;
                                break;
                            } while (numDocs < 4192);
                            matchingVectorsReader.rawDocs(this.rawDocLengths, this.rawDocLengths2, start, numDocs);
                            termVectorsWriter.addRawDocuments(matchingVectorsReader, this.rawDocLengths, this.rawDocLengths2, numDocs);
                            if (this.checkAbort == null) continue;
                            this.checkAbort.work(300 * numDocs);
                            continue;
                        }
                        TermFreqVector[] vectors = reader.getTermFreqVectors(docNum);
                        termVectorsWriter.addAllDocVectors(vectors);
                        ++docNum;
                        if (this.checkAbort == null) continue;
                        this.checkAbort.work(300.0);
                        continue;
                    }
                    ++docNum;
                }
            }
        }
        finally {
            termVectorsWriter.close();
        }
        long tvxSize = this.directory.fileLength(this.segment + "." + "tvx");
        if ((long)(4 + this.mergedDocs * 16) != tvxSize) {
            throw new RuntimeException("mergeVectors produced an invalid result: mergedDocs is " + this.mergedDocs + " but tvx size is " + tvxSize + "; now aborting this merge to prevent index corruption");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms() throws CorruptIndexException, IOException {
        try {
            this.freqOutput = this.directory.createOutput(this.segment + ".frq");
            if (this.hasProx()) {
                this.proxOutput = this.directory.createOutput(this.segment + ".prx");
            }
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos, this.termIndexInterval);
            this.skipInterval = this.termInfosWriter.skipInterval;
            this.maxSkipLevels = this.termInfosWriter.maxSkipLevels;
            this.skipListWriter = new DefaultSkipListWriter(this.skipInterval, this.maxSkipLevels, this.mergedDocs, this.freqOutput, this.proxOutput);
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws CorruptIndexException, IOException {
        int base = 0;
        int readerCount = this.readers.size();
        for (int i = 0; i < readerCount; ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            TermEnum termEnum = reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            int[] docMap = smi.getDocMap();
            if (docMap != null) {
                if (this.docMaps == null) {
                    this.docMaps = new int[readerCount][];
                    this.delCounts = new int[readerCount];
                }
                this.docMaps[i] = docMap;
                this.delCounts[i] = smi.reader.maxDoc() - smi.reader.numDocs();
            }
            base += reader.numDocs();
            if (smi.next()) {
                this.queue.put(smi);
                continue;
            }
            smi.close();
        }
        SegmentMergeInfo[] match = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            int df = this.mergeTermInfo(match, matchSize);
            if (this.checkAbort != null) {
                this.checkAbort.work((double)df / 3.0);
            }
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match[--matchSize]).next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    private final int mergeTermInfo(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput != null ? this.proxOutput.getFilePointer() : 0L;
        int df = this.fieldInfos.fieldInfo((String)smis[0].term.field).omitTf ? this.appendPostingsNoTf(smis, n) : this.appendPostings(smis, n);
        long skipPointer = this.skipListWriter.writeSkip(this.freqOutput);
        if (df > 0) {
            this.termInfo.set(df, freqPointer, proxPointer, (int)(skipPointer - freqPointer));
            this.termInfosWriter.add(smis[0].term, this.termInfo);
        }
        return df;
    }

    int[][] getDocMaps() {
        return this.docMaps;
    }

    int[] getDelCounts() {
        return this.delCounts;
    }

    private final int appendPostings(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        int lastDoc = 0;
        int df = 0;
        this.skipListWriter.resetSkip();
        boolean storePayloads = this.fieldInfos.fieldInfo((String)smis[0].term.field).storePayloads;
        int lastPayloadLength = -1;
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.getPositions();
            if (!$assertionsDisabled && postings == null) {
                throw new AssertionError();
            }
            int base = smi.base;
            int[] docMap = smi.getDocMap();
            postings.seek(smi.termEnum);
            while (postings.next()) {
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                if ((doc += base) < 0 || df > 0 && doc <= lastDoc) {
                    throw new CorruptIndexException("docs out of order (" + doc + " <= " + lastDoc + " )");
                }
                if (++df % this.skipInterval == 0) {
                    this.skipListWriter.setSkipData(lastDoc, storePayloads, lastPayloadLength);
                    this.skipListWriter.bufferSkip(df);
                }
                int docCode = doc - lastDoc << 1;
                lastDoc = doc;
                int freq = postings.freq();
                if (freq == 1) {
                    this.freqOutput.writeVInt(docCode | 1);
                } else {
                    this.freqOutput.writeVInt(docCode);
                    this.freqOutput.writeVInt(freq);
                }
                int lastPosition = 0;
                for (int j = 0; j < freq; ++j) {
                    int position = postings.nextPosition();
                    int delta = position - lastPosition;
                    if (storePayloads) {
                        int payloadLength = postings.getPayloadLength();
                        if (payloadLength == lastPayloadLength) {
                            this.proxOutput.writeVInt(delta * 2);
                        } else {
                            this.proxOutput.writeVInt(delta * 2 + 1);
                            this.proxOutput.writeVInt(payloadLength);
                            lastPayloadLength = payloadLength;
                        }
                        if (payloadLength > 0) {
                            if (this.payloadBuffer == null || this.payloadBuffer.length < payloadLength) {
                                this.payloadBuffer = new byte[payloadLength];
                            }
                            postings.getPayload(this.payloadBuffer, 0);
                            this.proxOutput.writeBytes(this.payloadBuffer, 0, payloadLength);
                        }
                    } else {
                        this.proxOutput.writeVInt(delta);
                    }
                    lastPosition = position;
                }
            }
        }
        return df;
    }

    private final int appendPostingsNoTf(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        int lastDoc = 0;
        int df = 0;
        this.skipListWriter.resetSkip();
        int lastPayloadLength = -1;
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.getPositions();
            if (!$assertionsDisabled && postings == null) {
                throw new AssertionError();
            }
            int base = smi.base;
            int[] docMap = smi.getDocMap();
            postings.seek(smi.termEnum);
            while (postings.next()) {
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                if ((doc += base) < 0 || df > 0 && doc <= lastDoc) {
                    throw new CorruptIndexException("docs out of order (" + doc + " <= " + lastDoc + " )");
                }
                if (++df % this.skipInterval == 0) {
                    this.skipListWriter.setSkipData(lastDoc, false, lastPayloadLength);
                    this.skipListWriter.bufferSkip(df);
                }
                int docCode = doc - lastDoc;
                lastDoc = doc;
                this.freqOutput.writeVInt(docCode);
            }
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms() throws IOException {
        byte[] normBuffer = null;
        IndexOutput output = null;
        try {
            for (int i = 0; i < this.fieldInfos.size(); ++i) {
                FieldInfo fi = this.fieldInfos.fieldInfo(i);
                if (!fi.isIndexed || fi.omitNorms) continue;
                if (output == null) {
                    output = this.directory.createOutput(this.segment + "." + "nrm");
                    output.writeBytes(NORMS_HEADER, NORMS_HEADER.length);
                }
                for (int j = 0; j < this.readers.size(); ++j) {
                    IndexReader reader = (IndexReader)this.readers.elementAt(j);
                    int maxDoc = reader.maxDoc();
                    if (normBuffer == null || normBuffer.length < maxDoc) {
                        normBuffer = new byte[maxDoc];
                    }
                    reader.norms(fi.name, normBuffer, 0);
                    if (!reader.hasDeletions()) {
                        output.writeBytes(normBuffer, maxDoc);
                    } else {
                        for (int k = 0; k < maxDoc; ++k) {
                            if (reader.isDeleted(k)) continue;
                            output.writeByte(normBuffer[k]);
                        }
                    }
                    if (this.checkAbort == null) continue;
                    this.checkAbort.work(maxDoc);
                }
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    static {
        $assertionsDisabled = !SegmentMerger.class.desiredAssertionStatus();
        NORMS_HEADER = new byte[]{78, 82, 77, -1};
    }

    static final class CheckAbort {
        private double workCount;
        private MergePolicy.OneMerge merge;
        private Directory dir;

        public CheckAbort(MergePolicy.OneMerge merge, Directory dir) {
            this.merge = merge;
            this.dir = dir;
        }

        public void work(double units) throws MergePolicy.MergeAbortedException {
            this.workCount += units;
            if (this.workCount >= 10000.0) {
                this.merge.checkAborted(this.dir);
                this.workCount = 0.0;
            }
        }
    }
}

