/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerFactory;

public class TokenizerChain
extends SolrAnalyzer {
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public TokenFilterFactory[] getTokenFilterFactories() {
        return this.filters;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream ts = this.tokenizer.create(reader);
        for (int i = 0; i < this.filters.length; ++i) {
            ts = this.filters[i].create(ts);
        }
        return ts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        sb.append(this.tokenizer);
        for (TokenFilterFactory filter : this.filters) {
            sb.append(", ");
            sb.append(filter);
        }
        sb.append(')');
        return sb.toString();
    }
}

