/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;

public class JettySolrRunner {
    Server server;
    FilterHolder dispatchFilter;

    public JettySolrRunner(String context, int port) {
        this.init(context, port);
    }

    public JettySolrRunner(String context, int port, String solrConfigFilename) {
        this.init(context, port);
        this.dispatchFilter.setInitParameter("solrconfig-filename", solrConfigFilename);
    }

    private void init(String context, int port) {
        this.server = new Server(port);
        this.server.setStopAtShutdown(true);
        Context root = new Context((HandlerContainer)this.server, context, 1);
        root.addServlet(Servlet404.class, "/*");
        this.dispatchFilter = root.addFilter(SolrDispatchFilter.class, "*", 1);
    }

    public void start() throws Exception {
        if (!this.server.isRunning()) {
            this.server.start();
        }
    }

    public void stop() throws Exception {
        if (this.server.isRunning()) {
            this.server.stop();
            this.server.join();
        }
    }

    public int getLocalPort() {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new RuntimeException("Jetty Server has no Connectors");
        }
        return conns[0].getLocalPort();
    }

    public static void main(String[] args) {
        try {
            JettySolrRunner jetty = new JettySolrRunner("/solr", 3456);
            jetty.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Servlet404
    extends HttpServlet {
        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }
}

