/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.StandardRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestHandlers {
    public static Logger log = Logger.getLogger(RequestHandlers.class.getName());
    public static final String DEFAULT_HANDLER_NAME = "standard";
    protected final SolrCore core;
    private final Map<String, SolrRequestHandler> handlers = Collections.synchronizedMap(new HashMap());

    private static String normalize(String p) {
        if (p != null && p.endsWith("/") && p.length() > 1) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public RequestHandlers(SolrCore core) {
        this.core = core;
    }

    public SolrRequestHandler get(String handlerName) {
        return this.handlers.get(RequestHandlers.normalize(handlerName));
    }

    public SolrRequestHandler register(String handlerName, SolrRequestHandler handler) {
        String norm = RequestHandlers.normalize(handlerName);
        if (handler == null) {
            return this.handlers.remove(norm);
        }
        SolrRequestHandler old = this.handlers.put(norm, handler);
        if (handlerName != null && handlerName != "" && handler instanceof SolrInfoMBean) {
            this.core.getInfoRegistry().put(handlerName, handler);
        }
        return old;
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    void initHandlersFromConfig(Config config) {
        final RequestHandlers handlers = this;
        AbstractPluginLoader<SolrRequestHandler> loader = new AbstractPluginLoader<SolrRequestHandler>("[solrconfig.xml] requestHandler", true, true){

            @Override
            protected SolrRequestHandler create(ResourceLoader config, String name, String className, Node node) throws Exception {
                String startup = DOMUtil.getAttr((Node)node, (String)"startup");
                if (startup != null) {
                    if ("lazy".equals(startup)) {
                        log.info("adding lazy requestHandler: " + className);
                        NamedList args = DOMUtil.childNodesToNamedList((Node)node);
                        return new LazyRequestHandlerWrapper(RequestHandlers.this.core, className, args);
                    }
                    throw new Exception("Unknown startup value: '" + startup + "' for: " + className);
                }
                return (SolrRequestHandler)super.create(config, name, className, node);
            }

            @Override
            protected SolrRequestHandler register(String name, SolrRequestHandler plugin) throws Exception {
                return handlers.register(name, plugin);
            }

            @Override
            protected void init(SolrRequestHandler plugin, Node node) throws Exception {
                plugin.init(DOMUtil.childNodesToNamedList((Node)node));
            }
        };
        NodeList nodes = (NodeList)config.evaluate("requestHandler", XPathConstants.NODESET);
        SolrRequestHandler defaultHandler = (SolrRequestHandler)loader.load(config.getResourceLoader(), nodes);
        if (defaultHandler == null && (defaultHandler = this.get(DEFAULT_HANDLER_NAME)) == null) {
            defaultHandler = new StandardRequestHandler();
            this.register(DEFAULT_HANDLER_NAME, defaultHandler);
        }
        this.register(null, defaultHandler);
        this.register("", defaultHandler);
    }

    private static final class LazyRequestHandlerWrapper
    implements SolrRequestHandler,
    SolrInfoMBean {
        private final SolrCore core;
        private String _className;
        private NamedList _args;
        private SolrRequestHandler _handler;

        public LazyRequestHandlerWrapper(SolrCore core, String className, NamedList args) {
            this.core = core;
            this._className = className;
            this._args = args;
            this._handler = null;
        }

        public void init(NamedList args) {
        }

        public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
            this.getWrappedHandler().handleRequest(req, rsp);
        }

        public synchronized SolrRequestHandler getWrappedHandler() {
            if (this._handler == null) {
                try {
                    this._handler = this.core.createRequestHandler(this._className);
                    this._handler.init(this._args);
                    if (this._handler instanceof ResourceLoaderAware) {
                        ((ResourceLoaderAware)((Object)this._handler)).inform(this.core.getSolrConfig().getResourceLoader());
                    }
                    if (this._handler instanceof SolrCoreAware) {
                        ((SolrCoreAware)((Object)this._handler)).inform(this.core);
                    }
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "lazy loading error", (Throwable)ex);
                }
            }
            return this._handler;
        }

        public String getHandlerClass() {
            return this._className;
        }

        public String getName() {
            return "Lazy[" + this._className + "]";
        }

        public String getDescription() {
            if (this._handler == null) {
                return this.getName();
            }
            return this._handler.getDescription();
        }

        public String getVersion() {
            String rev = "$Revision: 601975 $";
            if (this._handler != null) {
                rev = rev + " :: " + this._handler.getVersion();
            }
            return rev;
        }

        public String getSourceId() {
            String rev = "$Id: RequestHandlers.java 601975 2007-12-07 03:49:52Z ryan $";
            if (this._handler != null) {
                rev = rev + " :: " + this._handler.getSourceId();
            }
            return rev;
        }

        public String getSource() {
            String rev = "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/core/RequestHandlers.java $";
            if (this._handler != null) {
                rev = rev + "\n" + this._handler.getSource();
            }
            return rev;
        }

        public URL[] getDocs() {
            if (this._handler == null) {
                return null;
            }
            return this._handler.getDocs();
        }

        public SolrInfoMBean.Category getCategory() {
            return SolrInfoMBean.Category.QUERYHANDLER;
        }

        public NamedList getStatistics() {
            if (this._handler != null) {
                return this._handler.getStatistics();
            }
            SimpleOrderedMap lst = new SimpleOrderedMap();
            lst.add("note", (Object)"not initialized yet");
            return lst;
        }
    }
}

