/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.SingleThreadedCSVLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;

public class CSVRequestHandler
extends RequestHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessingChain(params.get("update.processor"));
        UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
        try {
            SingleThreadedCSVLoader loader = new SingleThreadedCSVLoader(req, processor);
            Iterable<ContentStream> streams = req.getContentStreams();
            if (streams == null) {
                if (!RequestHandlerUtils.handleCommit(processor, params, false)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content stream");
                }
            } else {
                for (ContentStream stream : streams) {
                    Reader reader = stream.getReader();
                    try {
                        loader.errHeader = "CSVLoader: input=" + stream.getSourceInfo();
                        loader.load(reader);
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)reader);
                    }
                }
                RequestHandlerUtils.handleCommit(processor, params, false);
            }
        }
        finally {
            processor.finish();
        }
    }

    public String getDescription() {
        return "Add/Update multiple documents with CSV formatted rows";
    }

    public String getVersion() {
        return "$Revision:$";
    }

    public String getSourceId() {
        return "$Id:$";
    }

    public String getSource() {
        return "$URL:$";
    }
}

