/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MagicDetector
implements Detector {
    private final MediaType type;
    private final int length;
    private final byte[] pattern;
    private final byte[] mask;
    private final byte[] sourceBuffer;
    private final byte[] compareBuffer;
    private final long offsetRangeBegin;
    private final long offsetRangeEnd;

    public MagicDetector(MediaType type, byte[] pattern) {
        this(type, pattern, 0L);
    }

    public MagicDetector(MediaType type, byte[] pattern, long offset) {
        this(type, pattern, null, offset, offset);
    }

    public MagicDetector(MediaType type, byte[] pattern, byte[] mask, long offsetRangeBegin, long offsetRangeEnd) {
        if (type == null) {
            throw new IllegalArgumentException("Matching media type is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Magic match pattern is null");
        }
        if (mask != null && mask.length != pattern.length) {
            throw new IllegalArgumentException("Different pattern and mask lengths: " + pattern.length + " != " + mask.length);
        }
        if (offsetRangeBegin < 0L || offsetRangeEnd < offsetRangeBegin) {
            throw new IllegalArgumentException("Invalid offset range: [" + offsetRangeBegin + "," + offsetRangeEnd + "]");
        }
        this.type = type;
        this.length = pattern.length;
        this.pattern = pattern;
        this.mask = mask;
        this.sourceBuffer = new byte[this.length];
        this.compareBuffer = mask != null ? new byte[this.length] : this.sourceBuffer;
        this.offsetRangeBegin = offsetRangeBegin;
        this.offsetRangeEnd = offsetRangeEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(this.length);
        try {
            long offset = 0L;
            while (offset < this.offsetRangeBegin) {
                long n = input.skip(this.offsetRangeBegin - offset);
                if (n > 0L) {
                    offset += n;
                    continue;
                }
                if (input.read() != -1) {
                    ++offset;
                    continue;
                }
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            while (offset < this.offsetRangeBegin + (long)this.sourceBuffer.length) {
                int i = (int)(offset - this.offsetRangeBegin);
                int n = input.read(this.sourceBuffer, i, this.sourceBuffer.length - i);
                if (n == -1) {
                    MediaType mediaType = MediaType.OCTET_STREAM;
                    return mediaType;
                }
                offset += (long)n;
            }
            while (true) {
                if (this.mask != null) {
                    for (int i = 0; i < this.length; ++i) {
                        this.compareBuffer[i] = (byte)(this.sourceBuffer[i] & this.mask[i]);
                    }
                }
                if (Arrays.equals(this.pattern, this.compareBuffer)) {
                    MediaType i = this.type;
                    return i;
                }
                if (offset >= this.offsetRangeEnd + (long)this.sourceBuffer.length) break;
                int c = input.read();
                if (c == -1) {
                    MediaType mediaType = MediaType.OCTET_STREAM;
                    return mediaType;
                }
                System.arraycopy(this.sourceBuffer, 1, this.sourceBuffer, 0, this.length - 1);
                this.sourceBuffer[this.length - 1] = (byte)c;
                ++offset;
            }
            MediaType mediaType = MediaType.OCTET_STREAM;
            return mediaType;
        }
        finally {
            input.reset();
        }
    }
}

