/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.IOException;
import java.io.Writer;
import org.apache.tika.language.NGramProfile;

public class ProfilingWriter
extends Writer {
    private final NGramProfile profile = new NGramProfile("suspect", 3, 3);
    private final StringBuffer buffer = new StringBuffer("_");

    private void addWord() {
        if (this.buffer.length() > 1) {
            this.buffer.append("_");
            this.profile.add(this.buffer);
            this.buffer.setLength(1);
        }
    }

    public NGramProfile getProfile() {
        return this.profile;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(cbuf[off + i]);
            if (Character.isLetter(c)) {
                this.buffer.append(c);
                continue;
            }
            this.addWord();
        }
    }

    public void close() throws IOException {
        this.addWord();
    }

    public void flush() {
    }
}

