/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaType {
    private static final Map<String, String> NO_PARAMETERS = new TreeMap<String, String>();
    private static final Pattern SPECIAL = Pattern.compile("[\\(\\)<>@,;:\\\\\"/\\[\\]\\?=]");
    private static final Pattern SPECIAL_OR_WHITESPACE = Pattern.compile("[\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\s]");
    public static final MediaType OCTET_STREAM = new MediaType("application", "octet-stream", NO_PARAMETERS);
    public static final MediaType TEXT_PLAIN = new MediaType("text", "plain", NO_PARAMETERS);
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml", NO_PARAMETERS);
    private final String type;
    private final String subtype;
    private final SortedMap<String, String> parameters;

    public static MediaType parse(String string) {
        int colon = string.indexOf(59);
        if (colon != -1 && colon != string.length() - 1) {
            String primarySubString = string.substring(0, colon);
            String parameters = string.substring(colon + 1, string.length());
            MediaType type = MediaType.parseNoParams(primarySubString);
            String[] paramBases = parameters.split(";");
            for (int i = 0; i < paramBases.length; ++i) {
                String[] paramToks = paramBases[i].split("=");
                String paramName = paramToks[0].trim();
                String paramValue = paramToks[1].trim();
                type.parameters.put(paramName, paramValue);
            }
            return type;
        }
        return MediaType.parseNoParams(string);
    }

    private static MediaType parseNoParams(String string) {
        int slash = string.indexOf(47);
        if (slash != -1) {
            String type = string.substring(0, slash).trim();
            String subtype = string.substring(slash + 1).trim();
            if (type.length() > 0 && subtype.length() > 0) {
                return new MediaType(type, subtype);
            }
        }
        return null;
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type.trim().toLowerCase();
        this.subtype = subtype.trim().toLowerCase();
        this.parameters = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.parameters.put(entry.getKey().trim().toLowerCase(), entry.getValue());
        }
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, NO_PARAMETERS);
    }

    private static Map<String, String> union(Map<String, String> a, Map<String, String> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        HashMap<String, String> union = new HashMap<String, String>();
        union.putAll(a);
        union.putAll(b);
        return union;
    }

    public MediaType(MediaType type, Map<String, String> parameters) {
        this(type.type, type.subtype, MediaType.union(type.parameters, parameters));
    }

    public MediaType getBaseType() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        return new MediaType(this.type, this.subtype);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isSpecializationOf(MediaType that) {
        if (OCTET_STREAM.equals(that)) {
            return true;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.parameters.entrySet().containsAll(that.parameters.entrySet())) {
            return false;
        }
        if (TEXT_PLAIN.equals(that.getBaseType())) {
            return true;
        }
        if (APPLICATION_XML.equals(that.getBaseType()) && this.subtype.endsWith("+xml")) {
            return true;
        }
        return this.subtype.equals(that.subtype);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        builder.append('/');
        builder.append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            builder.append("; ");
            builder.append(entry.getKey());
            builder.append("=");
            String value = entry.getValue();
            if (SPECIAL_OR_WHITESPACE.matcher(value).find()) {
                builder.append('\"');
                builder.append(SPECIAL.matcher(value).replaceAll("\\\\$0"));
                builder.append('\"');
                continue;
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MediaType) {
            MediaType that = (MediaType)object;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.parameters.equals(that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.type.hashCode();
        hash = hash * 31 + this.subtype.hashCode();
        hash = hash * 31 + this.parameters.hashCode();
        return hash;
    }
}

