/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.CapitalizationFilterFactory;

class CapitalizationFilter
extends TokenFilter {
    protected final CapitalizationFilterFactory factory;

    public CapitalizationFilter(TokenStream in, CapitalizationFilterFactory factory) {
        super(in);
        this.factory = factory;
    }

    public Token next(Token token) throws IOException {
        Token t = this.input.next(token);
        if (t != null) {
            char[] termBuffer = t.termBuffer();
            int termBufferLength = t.termLength();
            char[] backup = null;
            if (this.factory.maxWordCount < Integer.MAX_VALUE) {
                System.arraycopy(termBuffer, 0, backup, 0, termBufferLength);
            }
            if (termBuffer.length < this.factory.maxTokenLength) {
                int wordCount = 0;
                int lastWordStart = 0;
                for (int i = 0; i < termBufferLength; ++i) {
                    int len;
                    char c = termBuffer[i];
                    if (c > ' ' && c != '.' || (len = i - lastWordStart) <= 0) continue;
                    this.factory.processWord(termBuffer, lastWordStart, len, wordCount++);
                    lastWordStart = i + 1;
                    ++i;
                }
                if (lastWordStart < termBuffer.length) {
                    this.factory.processWord(termBuffer, lastWordStart, termBuffer.length - lastWordStart, wordCount++);
                }
                if (wordCount > this.factory.maxWordCount) {
                    t.setTermBuffer(backup, 0, termBufferLength);
                }
            }
        }
        return t;
    }
}

