/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.JmxMonitoredMap;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.MoreLikeThisComponent;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.highlight.DefaultSolrHighlighter;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.BinaryResponseWriter;
import org.apache.solr.request.JSONResponseWriter;
import org.apache.solr.request.PythonResponseWriter;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.RawResponseWriter;
import org.apache.solr.request.RubyResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.XMLResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.update.DirectUpdateHandler;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.apache.solr.util.plugin.NamedListPluginLoader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SolrCore
implements SolrInfoMBean {
    public static final String version = "1.0";
    public static Logger log = Logger.getLogger(SolrCore.class.getName());
    private String name;
    private String logid;
    private final CoreDescriptor coreDescriptor;
    private final SolrConfig solrConfig;
    private final IndexSchema schema;
    private final String dataDir;
    private final UpdateHandler updateHandler;
    private final long startTime;
    private final RequestHandlers reqHandlers;
    private final SolrHighlighter highlighter;
    private final Map<String, SearchComponent> searchComponents;
    private final Map<String, UpdateRequestProcessorChain> updateProcessorChains;
    private final Map<String, SolrInfoMBean> infoRegistry;
    @Deprecated
    private static SolrCore instance;
    static int boolean_query_max_clause_count;
    List<SolrEventListener> firstSearcherListeners;
    List<SolrEventListener> newSearcherListeners;
    private static Set<String> dirs;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private List<CloseHook> closeHooks = null;
    private RefCounted<SolrIndexSearcher> _searcher;
    private final LinkedList<RefCounted<SolrIndexSearcher>> _searchers = new LinkedList();
    final ExecutorService searcherExecutor = Executors.newSingleThreadExecutor();
    private int onDeckSearchers;
    private Object searcherLock = new Object();
    private final int maxWarmingSearchers;
    private QueryResponseWriter defaultResponseWriter;
    private final Map<String, QueryResponseWriter> responseWriters = new HashMap<String, QueryResponseWriter>();
    private final Map<String, QParserPlugin> qParserPlugins = new HashMap<String, QParserPlugin>();
    private final HashMap<String, ValueSourceParser> valueSourceParsers = new HashMap();

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void booleanQueryMaxClauseCount() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (boolean_query_max_clause_count == Integer.MIN_VALUE) {
                boolean_query_max_clause_count = this.solrConfig.booleanQueryMaxClauseCount;
                BooleanQuery.setMaxClauseCount((int)boolean_query_max_clause_count);
            } else if (boolean_query_max_clause_count != this.solrConfig.booleanQueryMaxClauseCount) {
                log.fine("BooleanQuery.maxClauseCount= " + boolean_query_max_clause_count + ", ignoring " + this.solrConfig.booleanQueryMaxClauseCount);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.solrConfig.getResourceLoader();
    }

    public String getConfigResource() {
        return this.solrConfig.getResourceName();
    }

    @Deprecated
    public String getConfigFile() {
        return this.solrConfig.getResourceName();
    }

    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public String getSchemaResource() {
        return this.schema.getResourceName();
    }

    @Deprecated
    public String getSchemaFile() {
        return this.schema.getResourceName();
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getIndexDir() {
        return this.dataDir + "index/";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
        this.logid = v == null ? "" : "[" + v + "] ";
    }

    public String getLogId() {
        return this.logid;
    }

    public Map<String, SolrInfoMBean> getInfoRegistry() {
        return this.infoRegistry;
    }

    public List<SolrEventListener> parseListener(String path) {
        ArrayList<SolrEventListener> lst = new ArrayList<SolrEventListener>();
        log.info(this.logid + "Searching for listeners: " + path);
        NodeList nodes = (NodeList)this.solrConfig.evaluate(path, XPathConstants.NODESET);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String className = DOMUtil.getAttr((Node)node, (String)"class");
                SolrEventListener listener = this.createEventListener(className);
                listener.init(DOMUtil.childNodesToNamedList((Node)node));
                lst.add(listener);
                log.info(this.logid + "Added SolrEventListener: " + listener);
            }
        }
        return lst;
    }

    private void parseListeners() {
        this.firstSearcherListeners = this.parseListener("//listener[@event=\"firstSearcher\"]");
        this.newSearcherListeners = this.parseListener("//listener[@event=\"newSearcher\"]");
    }

    public void registerFirstSearcherListener(SolrEventListener listener) {
        this.firstSearcherListeners.add(listener);
    }

    public void registerNewSearcherListener(SolrEventListener listener) {
        this.newSearcherListeners.add(listener);
    }

    public void registerResponseWriter(String name, QueryResponseWriter responseWriter) {
        this.responseWriters.put(name, responseWriter);
    }

    public SolrIndexSearcher newSearcher(String name) throws IOException {
        return this.newSearcher(name, false);
    }

    public SolrIndexSearcher newSearcher(String name, boolean readOnly) throws IOException {
        return new SolrIndexSearcher(this, this.schema, "main", IndexReader.open((Directory)FSDirectory.getDirectory((String)this.getIndexDir()), (boolean)readOnly), true, false);
    }

    void initIndex() {
        try {
            Directory dir;
            File dirFile = new File(this.getIndexDir());
            boolean indexExists = dirFile.canRead();
            boolean firstTime = dirs.add(dirFile.getCanonicalPath());
            boolean removeLocks = this.solrConfig.getBool("mainIndex/unlockOnStartup", false);
            if (indexExists && firstTime && removeLocks && (dir = SolrIndexWriter.getDirectory(this.getIndexDir(), this.solrConfig.mainIndexConfig)) != null && IndexWriter.isLocked((Directory)dir)) {
                log.warning(this.logid + "WARNING: Solr index directory '" + this.getIndexDir() + "' is locked.  Unlocking...");
                IndexWriter.unlock((Directory)dir);
            }
            if (!indexExists) {
                log.warning(this.logid + "Solr index directory '" + dirFile + "' doesn't exist." + " Creating new index...");
                SolrIndexWriter writer = new SolrIndexWriter("SolrCore.initIndex", this.getIndexDir(), true, this.schema, this.solrConfig.mainIndexConfig);
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T createInstance(String className, Class<T> cast, String msg) {
        Class clazz = null;
        if (msg == null) {
            msg = "SolrCore Object";
        }
        try {
            try {
                clazz = this.solrConfig.getResourceLoader().findClass(className, new String[0]);
                if (cast != null && !cast.isAssignableFrom(clazz)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " is not a " + cast.getName());
                }
                Constructor cons = clazz.getConstructor(SolrCore.class);
                return cons.newInstance(this);
            }
            catch (NoSuchMethodException xnomethod) {
                return clazz.newInstance();
            }
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error Instantiating " + msg + ", " + className + " failed to instantiate " + cast.getName(), (Throwable)e);
        }
    }

    public SolrEventListener createEventListener(String className) {
        return this.createInstance(className, SolrEventListener.class, "Event Listener");
    }

    public SolrRequestHandler createRequestHandler(String className) {
        return this.createInstance(className, SolrRequestHandler.class, "Request Handler");
    }

    private UpdateHandler createUpdateHandler(String className) {
        return this.createInstance(className, UpdateHandler.class, "Update Handler");
    }

    private SolrHighlighter createHighlighter(String className) {
        return this.createInstance(className, SolrHighlighter.class, "Highlighter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static SolrCore getSolrCore() {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            if (instance == null) {
                try {
                    instance = new SolrCore(null, null, new SolrConfig(), null, null);
                }
                catch (Exception xany) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error creating core", (Throwable)xany);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SolrCore(String dataDir, IndexSchema schema) throws ParserConfigurationException, IOException, SAXException {
        this(null, dataDir, new SolrConfig(), schema, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore(String name, String dataDir, SolrConfig config, IndexSchema schema, CoreDescriptor cd) {
        Class<SolrCore> clazz = SolrCore.class;
        synchronized (SolrCore.class) {
            this.coreDescriptor = cd;
            instance = this;
            this.setName(name);
            SolrResourceLoader loader = config.getResourceLoader();
            if (dataDir == null) {
                dataDir = config.get("dataDir", loader.getInstanceDir() + "data/");
            }
            dataDir = SolrResourceLoader.normalizeDir(dataDir);
            log.info(this.logid + "Opening new SolrCore at " + loader.getInstanceDir() + ", dataDir=" + dataDir);
            if (schema == null) {
                schema = new IndexSchema(config, "schema.xml", null);
            }
            if (config.jmxConfig.enabled) {
                this.infoRegistry = new JmxMonitoredMap(name, config.jmxConfig);
            } else {
                log.info("JMX monitoring not detected for core: " + name);
                this.infoRegistry = new LinkedHashMap<String, SolrInfoMBean>();
            }
            this.schema = schema;
            this.dataDir = dataDir;
            this.solrConfig = config;
            this.startTime = System.currentTimeMillis();
            this.maxWarmingSearchers = config.getInt("query/maxWarmingSearchers", Integer.MAX_VALUE);
            this.booleanQueryMaxClauseCount();
            this.parseListeners();
            this.initIndex();
            this.initWriters();
            this.initQParsers();
            this.initValueSourceParsers();
            this.searchComponents = SolrCore.loadSearchComponents(config);
            this.updateProcessorChains = this.loadUpdateProcessorChains();
            this.reqHandlers = new RequestHandlers(this);
            this.reqHandlers.initHandlersFromConfig(this.solrConfig);
            this.highlighter = this.createHighlighter(this.solrConfig.get("highlighting/@class", DefaultSolrHighlighter.class.getName()));
            this.highlighter.initalize(this.solrConfig);
            this.initDeprecatedSupport();
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        latch.await();
                        return null;
                    }
                });
                this.getSearcher(false, false, null);
                this.updateHandler = this.createUpdateHandler(this.solrConfig.get("updateHandler/@class", DirectUpdateHandler.class.getName()));
                this.infoRegistry.put("updateHandler", this.updateHandler);
                loader.inform(loader);
                loader.inform(this);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            finally {
                latch.countDown();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.infoRegistry.put("core", this);
            return;
        }
    }

    private Map<String, UpdateRequestProcessorChain> loadUpdateProcessorChains() {
        boolean requireName;
        HashMap<String, UpdateRequestProcessorChain> map = new HashMap<String, UpdateRequestProcessorChain>();
        String parsingErrorText = "Parsing Update Request Processor Chain";
        UpdateRequestProcessorChain def = null;
        XPath xpath = this.solrConfig.getXPath();
        NodeList nodes = (NodeList)this.solrConfig.evaluate("updateRequestProcessorChain", XPathConstants.NODESET);
        boolean bl = requireName = nodes.getLength() > 1;
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = DOMUtil.getAttr((Node)node, (String)"name", (String)(requireName ? "Parsing Update Request Processor Chain" : null));
                boolean isDefault = "true".equals(DOMUtil.getAttr((Node)node, (String)"default", null));
                NodeList links = null;
                try {
                    links = (NodeList)xpath.evaluate("processor", node, XPathConstants.NODESET);
                }
                catch (XPathExpressionException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading processors", (Throwable)e, false);
                }
                if (links == null || links.getLength() < 1) {
                    throw new RuntimeException("updateRequestProcessorChain require at least one processor");
                }
                final ArrayList factories = new ArrayList(links.getLength());
                AbstractPluginLoader<UpdateRequestProcessorFactory> loader = new AbstractPluginLoader<UpdateRequestProcessorFactory>("processor chain", false, false){

                    @Override
                    protected void init(UpdateRequestProcessorFactory plugin, Node node) throws Exception {
                        plugin.init(node == null ? null : DOMUtil.childNodesToNamedList((Node)node));
                    }

                    @Override
                    protected UpdateRequestProcessorFactory register(String name, UpdateRequestProcessorFactory plugin) throws Exception {
                        factories.add(plugin);
                        return null;
                    }
                };
                loader.load(this.solrConfig.getResourceLoader(), links);
                UpdateRequestProcessorChain chain = new UpdateRequestProcessorChain(factories.toArray(new UpdateRequestProcessorFactory[factories.size()]));
                if (isDefault || nodes.getLength() == 1) {
                    def = chain;
                }
                if (name == null) continue;
                map.put(name, chain);
            }
        }
        if (def == null) {
            UpdateRequestProcessorFactory[] factories = new UpdateRequestProcessorFactory[]{new RunUpdateProcessorFactory(), new LogUpdateProcessorFactory()};
            def = new UpdateRequestProcessorChain(factories);
        }
        map.put(null, def);
        map.put("", def);
        return map;
    }

    public UpdateRequestProcessorChain getUpdateProcessingChain(String name) {
        UpdateRequestProcessorChain chain = this.updateProcessorChains.get(name);
        if (chain == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown UpdateRequestProcessorChain: " + name);
        }
        return chain;
    }

    final void open() {
        this.refCount.incrementAndGet();
    }

    public void close() {
        int count = this.refCount.decrementAndGet();
        if (count > 0) {
            return;
        }
        if (count < 0) {
            log.severe("Too many close {count:" + count + "} on " + this + ". Please report this exception to solr-user@lucene.apache.org");
            return;
        }
        log.info(this.logid + " CLOSING SolrCore " + this);
        try {
            this.infoRegistry.clear();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.closeSearcher();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.searcherExecutor.shutdown();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        try {
            this.updateHandler.close();
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        if (this.closeHooks != null) {
            for (CloseHook hook : this.closeHooks) {
                hook.close(this);
            }
        }
    }

    public int getOpenCount() {
        return this.refCount.get();
    }

    public boolean isClosed() {
        return this.refCount.get() <= 0;
    }

    protected void finalize() {
        if (this.getOpenCount() != 0) {
            log.severe("REFCOUNT ERROR: unreferenced " + this + " (" + this.getName() + ") has a reference count of " + this.getOpenCount());
        }
    }

    public void addCloseHook(CloseHook hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ArrayList<CloseHook>();
        }
        this.closeHooks.add(hook);
    }

    @Deprecated
    public SolrQueryRequest getPingQueryRequest() {
        return this.solrConfig.getPingQueryRequest(this);
    }

    public SolrRequestHandler getRequestHandler(String handlerName) {
        return this.reqHandlers.get(handlerName);
    }

    public Map<String, SolrRequestHandler> getRequestHandlers() {
        return this.reqHandlers.getRequestHandlers();
    }

    public SolrHighlighter getHighlighter() {
        return this.highlighter;
    }

    public SolrRequestHandler registerRequestHandler(String handlerName, SolrRequestHandler handler) {
        return this.reqHandlers.register(handlerName, handler);
    }

    private static Map<String, SearchComponent> loadSearchComponents(SolrConfig config) {
        HashMap<String, SearchComponent> components = new HashMap<String, SearchComponent>();
        String xpath = "searchComponent";
        NamedListPluginLoader loader = new NamedListPluginLoader(xpath, components);
        loader.load(config.getResourceLoader(), (NodeList)config.evaluate(xpath, XPathConstants.NODESET));
        HashMap<String, Class<DebugComponent>> standardcomponents = new HashMap<String, Class<DebugComponent>>();
        standardcomponents.put("query", QueryComponent.class);
        standardcomponents.put("facet", FacetComponent.class);
        standardcomponents.put("mlt", MoreLikeThisComponent.class);
        standardcomponents.put("highlight", HighlightComponent.class);
        standardcomponents.put("debug", DebugComponent.class);
        for (Map.Entry entry : standardcomponents.entrySet()) {
            if (components.get(entry.getKey()) != null) continue;
            try {
                SearchComponent comp = (SearchComponent)((Class)entry.getValue()).newInstance();
                comp.init(null);
                components.put((String)entry.getKey(), comp);
            }
            catch (Exception e) {
                SolrConfig.severeErrors.add(e);
                SolrException.logOnce((Logger)log, null, (Throwable)e);
            }
        }
        return components;
    }

    public SearchComponent getSearchComponent(String name) {
        SearchComponent component = this.searchComponents.get(name);
        if (component == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Search Component: " + name);
        }
        return component;
    }

    public Map<String, SearchComponent> getSearchComponents() {
        return Collections.unmodifiableMap(this.searchComponents);
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public RefCounted<SolrIndexSearcher> getSearcher() {
        try {
            return this.getSearcher(false, true, null);
        }
        catch (IOException e) {
            SolrException.log((Logger)log, null, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getNewestSearcher(boolean openNew) {
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searchers.isEmpty()) {
                if (!openNew) {
                    return null;
                }
                throw new UnsupportedOperationException();
            }
            RefCounted<SolrIndexSearcher> newest = this._searchers.getLast();
            newest.incref();
            return newest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<SolrIndexSearcher> getSearcher(boolean forceNew, boolean returnSearcher, Future[] waitSearcher) throws IOException {
        SolrIndexSearcher tmp;
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            if (this.onDeckSearchers > 0 && !forceNew && this._searcher == null) {
                try {
                    this.searcherLock.wait();
                }
                catch (InterruptedException e) {
                    log.info(SolrException.toStr((Throwable)e));
                }
            }
            if (this._searcher != null && !forceNew) {
                if (returnSearcher) {
                    this._searcher.incref();
                    return this._searcher;
                }
                return null;
            }
            ++this.onDeckSearchers;
            if (this.onDeckSearchers < 1) {
                log.severe(this.logid + "ERROR!!! onDeckSearchers is " + this.onDeckSearchers);
                this.onDeckSearchers = 1;
            } else {
                if (this.onDeckSearchers > this.maxWarmingSearchers) {
                    --this.onDeckSearchers;
                    String msg = "Error opening new searcher. exceeded limit of maxWarmingSearchers=" + this.maxWarmingSearchers + ", try again later.";
                    log.warning(this.logid + "" + msg);
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, msg, true);
                }
                if (this.onDeckSearchers > 1) {
                    log.info(this.logid + "PERFORMANCE WARNING: Overlapping onDeckSearchers=" + this.onDeckSearchers);
                }
            }
        }
        try {
            tmp = new SolrIndexSearcher(this, this.schema, "main", IndexReader.open((Directory)FSDirectory.getDirectory((String)this.getIndexDir()), (boolean)true), true, true);
        }
        catch (Throwable th) {
            Object object2 = this.searcherLock;
            synchronized (object2) {
                --this.onDeckSearchers;
                this.searcherLock.notify();
            }
            throw new RuntimeException(th);
        }
        final SolrIndexSearcher newSearcher = tmp;
        RefCounted<SolrIndexSearcher> currSearcherHolder = null;
        final RefCounted<SolrIndexSearcher> newSearchHolder = this.newHolder(newSearcher);
        if (returnSearcher) {
            newSearchHolder.incref();
        }
        final boolean[] decrementOnDeckCount = new boolean[]{true};
        try {
            boolean alreadyRegistered = false;
            Object object3 = this.searcherLock;
            synchronized (object3) {
                this._searchers.add(newSearchHolder);
                if (this._searcher == null) {
                    if (this.solrConfig.getBool("query/useColdSearcher", false)) {
                        this.registerSearcher(newSearchHolder);
                        decrementOnDeckCount[0] = false;
                        alreadyRegistered = true;
                    }
                } else {
                    currSearcherHolder = this._searcher;
                    currSearcherHolder.incref();
                }
            }
            final SolrIndexSearcher currSearcher = currSearcherHolder == null ? null : currSearcherHolder.get();
            Future future = null;
            if (currSearcher != null) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            newSearcher.warm(currSearcher);
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher == null && this.firstSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.firstSearcherListeners) {
                                listener.newSearcher(newSearcher, null);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            if (currSearcher != null && this.newSearcherListeners.size() > 0) {
                future = this.searcherExecutor.submit(new Callable(){

                    public Object call() throws Exception {
                        try {
                            for (SolrEventListener listener : SolrCore.this.newSearcherListeners) {
                                listener.newSearcher(newSearcher, currSearcher);
                            }
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        return null;
                    }
                });
            }
            final RefCounted<SolrIndexSearcher> currSearcherHolderF = currSearcherHolder;
            if (!alreadyRegistered) {
                future = this.searcherExecutor.submit(new Callable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() throws Exception {
                        try {
                            decrementOnDeckCount[0] = false;
                            SolrCore.this.registerSearcher(newSearchHolder);
                        }
                        catch (Throwable e) {
                            SolrException.logOnce((Logger)log, null, (Throwable)e);
                        }
                        finally {
                            if (currSearcherHolderF != null) {
                                currSearcherHolderF.decref();
                            }
                        }
                        return null;
                    }
                });
            }
            if (waitSearcher != null) {
                waitSearcher[0] = future;
            }
            return returnSearcher ? newSearchHolder : null;
        }
        catch (Exception e) {
            SolrException.logOnce((Logger)log, null, (Throwable)e);
            if (currSearcherHolder != null) {
                currSearcherHolder.decref();
            }
            Object object4 = this.searcherLock;
            synchronized (object4) {
                if (decrementOnDeckCount[0]) {
                    --this.onDeckSearchers;
                }
                if (this.onDeckSearchers < 0) {
                    log.severe(this.logid + "ERROR!!! onDeckSearchers after decrement=" + this.onDeckSearchers);
                    this.onDeckSearchers = 0;
                }
                this.searcherLock.notify();
            }
            return returnSearcher ? newSearchHolder : null;
        }
    }

    private RefCounted<SolrIndexSearcher> newHolder(SolrIndexSearcher newSearcher) {
        RefCounted<SolrIndexSearcher> holder = new RefCounted<SolrIndexSearcher>(newSearcher){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    Object object = SolrCore.this.searcherLock;
                    synchronized (object) {
                        if (this.refcount.get() > 0) {
                            return;
                        }
                        SolrCore.this._searchers.remove(this);
                    }
                    ((SolrIndexSearcher)this.resource).close();
                }
                catch (IOException e) {
                    log.severe("Error closing searcher:" + SolrException.toStr((Throwable)e));
                }
            }
        };
        holder.incref();
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSearcher(RefCounted<SolrIndexSearcher> newSearcherHolder) throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            try {
                if (this._searcher != null) {
                    this._searcher.decref();
                    this._searcher = null;
                }
                this._searcher = newSearcherHolder;
                SolrIndexSearcher newSearcher = newSearcherHolder.get();
                newSearcher.register();
                log.info(this.logid + "Registered new searcher " + newSearcher);
            }
            catch (Throwable e) {
                SolrCore.log(e);
            }
            finally {
                --this.onDeckSearchers;
                this.searcherLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSearcher() {
        log.info(this.logid + "Closing main searcher on request.");
        Object object = this.searcherLock;
        synchronized (object) {
            if (this._searcher != null) {
                this._searcher.decref();
                this._searcher = null;
                this.infoRegistry.remove("currentSearcher");
            }
        }
    }

    public void execute(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        if (handler == null) {
            log.warning(this.logid + "Null Request Handler '" + req.getQueryType() + "' :" + req);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Null Request Handler '" + req.getQueryType() + "'", true);
        }
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        rsp.add("responseHeader", responseHeader);
        NamedList toLog = rsp.getToLog();
        toLog.add("webapp", req.getContext().get("webapp"));
        toLog.add("path", req.getContext().get("path"));
        toLog.add("params", (Object)("{" + req.getParamString() + "}"));
        handler.handleRequest(req, rsp);
        this.setResponseHeaderValues(handler, req, rsp);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toLog.size(); ++i) {
            String name = toLog.getName(i);
            Object val = toLog.getVal(i);
            sb.append(name).append("=").append(val).append(" ");
        }
        log.info(this.logid + sb.toString());
    }

    @Deprecated
    public void execute(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrRequestHandler handler = this.getRequestHandler(req.getQueryType());
        if (handler == null) {
            log.warning(this.logid + "Unknown Request Handler '" + req.getQueryType() + "' :" + req);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Request Handler '" + req.getQueryType() + "'", true);
        }
        this.execute(handler, req, rsp);
    }

    protected void setResponseHeaderValues(SolrRequestHandler handler, SolrQueryRequest req, SolrQueryResponse rsp) {
        String ep;
        NamedList responseHeader = rsp.getResponseHeader();
        int qtime = (int)(rsp.getEndTime() - req.getStartTime());
        responseHeader.add("status", (Object)(rsp.getException() == null ? 0 : 500));
        responseHeader.add("QTime", (Object)qtime);
        rsp.getToLog().add("status", (Object)(rsp.getException() == null ? 0 : 500));
        rsp.getToLog().add("QTime", (Object)qtime);
        SolrParams params = req.getParams();
        if (params.getBool("echoHandler", false)) {
            responseHeader.add("handler", (Object)handler.getName());
        }
        if ((ep = params.get("echoParams", null)) != null) {
            CommonParams.EchoParamStyle echoParams = CommonParams.EchoParamStyle.get((String)ep);
            if (echoParams == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value '" + ep + "' for " + "echoParams" + " parameter, use '" + CommonParams.EchoParamStyle.EXPLICIT + "' or '" + CommonParams.EchoParamStyle.ALL + "'");
            }
            if (echoParams == CommonParams.EchoParamStyle.EXPLICIT) {
                responseHeader.add("params", (Object)req.getOriginalParams().toNamedList());
            } else if (echoParams == CommonParams.EchoParamStyle.ALL) {
                responseHeader.add("params", (Object)req.getParams().toNamedList());
            }
        }
    }

    public static final void log(Throwable e) {
        SolrException.logOnce((Logger)log, null, (Throwable)e);
    }

    private void initWriters() {
        String xpath = "queryResponseWriter";
        NodeList nodes = (NodeList)this.solrConfig.evaluate(xpath, XPathConstants.NODESET);
        NamedListPluginLoader<QueryResponseWriter> loader = new NamedListPluginLoader<QueryResponseWriter>("[solrconfig.xml] " + xpath, this.responseWriters);
        this.defaultResponseWriter = (QueryResponseWriter)loader.load(this.solrConfig.getResourceLoader(), nodes);
        if (this.defaultResponseWriter == null) {
            this.defaultResponseWriter = this.responseWriters.get("standard");
            if (this.defaultResponseWriter == null) {
                this.defaultResponseWriter = new XMLResponseWriter();
            }
        }
        if (this.responseWriters.get("json") == null) {
            this.responseWriters.put("json", new JSONResponseWriter());
        }
        if (this.responseWriters.get("python") == null) {
            this.responseWriters.put("python", new PythonResponseWriter());
        }
        if (this.responseWriters.get("ruby") == null) {
            this.responseWriters.put("ruby", new RubyResponseWriter());
        }
        if (this.responseWriters.get("raw") == null) {
            this.responseWriters.put("raw", new RawResponseWriter());
        }
        if (this.responseWriters.get("javabin") == null) {
            this.responseWriters.put("javabin", new BinaryResponseWriter());
        }
    }

    public final QueryResponseWriter getQueryResponseWriter(String writerName) {
        QueryResponseWriter writer;
        if (writerName != null && (writer = this.responseWriters.get(writerName)) != null) {
            return writer;
        }
        return this.defaultResponseWriter;
    }

    public final QueryResponseWriter getQueryResponseWriter(SolrQueryRequest request) {
        return this.getQueryResponseWriter(request.getParam("wt"));
    }

    private void initQParsers() {
        String xpath = "queryParser";
        NodeList nodes = (NodeList)this.solrConfig.evaluate(xpath, XPathConstants.NODESET);
        NamedListPluginLoader<QParserPlugin> loader = new NamedListPluginLoader<QParserPlugin>("[solrconfig.xml] " + xpath, this.qParserPlugins);
        loader.load(this.solrConfig.getResourceLoader(), nodes);
        for (int i = 0; i < QParserPlugin.standardPlugins.length; i += 2) {
            try {
                String name = (String)QParserPlugin.standardPlugins[i];
                if (null != this.qParserPlugins.get(name)) continue;
                Class clazz = (Class)QParserPlugin.standardPlugins[i + 1];
                QParserPlugin plugin = (QParserPlugin)clazz.newInstance();
                this.qParserPlugins.put(name, plugin);
                plugin.init(null);
                continue;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public QParserPlugin getQueryPlugin(String parserName) {
        QParserPlugin plugin = this.qParserPlugins.get(parserName);
        if (plugin != null) {
            return plugin;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown query type '" + parserName + "'");
    }

    private void initValueSourceParsers() {
        String xpath = "valueSourceParser";
        NodeList nodes = (NodeList)this.solrConfig.evaluate(xpath, XPathConstants.NODESET);
        NamedListPluginLoader<ValueSourceParser> loader = new NamedListPluginLoader<ValueSourceParser>("[solrconfig.xml] " + xpath, this.valueSourceParsers);
        loader.load(this.solrConfig.getResourceLoader(), nodes);
        for (Map.Entry<String, ValueSourceParser> entry : ValueSourceParser.standardValueSourceParsers.entrySet()) {
            try {
                String name = entry.getKey();
                if (null != this.valueSourceParsers.get(name)) continue;
                ValueSourceParser valueSourceParser = entry.getValue();
                this.valueSourceParsers.put(name, valueSourceParser);
                valueSourceParser.init(null);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public ValueSourceParser getValueSourceParser(String parserName) {
        return this.valueSourceParsers.get(parserName);
    }

    private void initDeprecatedSupport() {
        String gettable = this.solrConfig.get("admin/gettableFiles", null);
        if (gettable != null) {
            log.warning("solrconfig.xml uses deprecated <admin/gettableFiles>, Please update your config to use the ShowFileRequestHandler.");
            if (this.getRequestHandler("/admin/file") == null) {
                NamedList invariants = new NamedList();
                HashSet<String> hide = new HashSet<String>();
                File configdir = new File(this.solrConfig.getResourceLoader().getConfigDir());
                for (String file : configdir.list()) {
                    hide.add(file.toUpperCase());
                }
                StringTokenizer st = new StringTokenizer(gettable);
                while (st.hasMoreTokens()) {
                    hide.remove(st.nextToken().toUpperCase());
                }
                for (String s : hide) {
                    invariants.add("hidden", (Object)s);
                }
                NamedList args = new NamedList();
                args.add("invariants", (Object)invariants);
                ShowFileRequestHandler handler = new ShowFileRequestHandler();
                handler.init(args);
                this.reqHandlers.register("/admin/file", handler);
                log.warning("adding ShowFileRequestHandler with hidden files: " + hide);
            }
        }
    }

    public CoreDescriptor getCoreDescriptor() {
        return this.coreDescriptor;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public String getDescription() {
        return "SolrCore";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSourceId() {
        return "$Id: SolrCore.java 691704 2008-09-03 18:09:56Z gsingers $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/core/SolrCore.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("coreName", (Object)(this.name == null ? "(null)" : this.name));
        lst.add("startTime", (Object)new Date(this.startTime));
        lst.add("refCount", (Object)this.getOpenCount());
        lst.add("aliases", this.getCoreDescriptor().getCoreContainer().getCoreNames(this));
        return lst;
    }

    static {
        boolean_query_max_clause_count = Integer.MIN_VALUE;
        dirs = new HashSet<String>();
    }
}

