/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.manager;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.StatementHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.StatementCache;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcContextImpl
implements JdbcContext {
    private static final Logger logger = Logger.getLogger(JdbcContextImpl.class);
    private Connection connection;
    private Statement statement;
    private boolean transactional;
    private int preparedStatementCacheSize = 10;
    private int cursorPreparedStatementCacheSize = 5;
    private int callableStatementCacheSize = 5;
    private StatementCache preparedStatementCache = new StatementCache(this.preparedStatementCacheSize);
    private StatementCache cursorPreparedStatementCache = new StatementCache(this.cursorPreparedStatementCacheSize);
    private StatementCache callableStatementCache = new StatementCache(this.callableStatementCacheSize);

    public JdbcContextImpl(Connection connection, boolean transactional) {
        this.connection = connection;
        this.transactional = transactional;
    }

    @Override
    public void destroy() {
        if (this.connection == null) {
            return;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                logger.log((Throwable)e);
            }
            this.statement = null;
        }
        try {
            this.preparedStatementCache.destroy();
        }
        catch (SQLException e) {
            logger.log((Throwable)e);
        }
        try {
            this.cursorPreparedStatementCache.destroy();
        }
        catch (SQLException e) {
            logger.log((Throwable)e);
        }
        try {
            this.callableStatementCache.destroy();
        }
        catch (SQLException e) {
            logger.log((Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            logger.log((Throwable)e);
        }
        this.connection = null;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public Statement getStatement() {
        if (this.statement != null) {
            return this.statement;
        }
        this.statement = ConnectionUtil.createStatement((Connection)this.connection);
        return this.statement;
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql) {
        PreparedStatement ps = (PreparedStatement)this.preparedStatementCache.get(sql);
        if (ps != null) {
            return ps;
        }
        ps = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql);
        this.preparedStatementCache.put(sql, ps);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T usingPreparedStatement(String sql, StatementHandler<T, ? super PreparedStatement> handler) {
        PreparedStatement ps = (PreparedStatement)this.preparedStatementCache.remove(sql);
        if (ps == null) {
            ps = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql);
        }
        try {
            T t = handler.handle(ps);
            return t;
        }
        finally {
            this.preparedStatementCache.put(sql, ps);
        }
    }

    @Override
    public PreparedStatement getPreparedStatement(String sql, int autoGeneratedKeys) {
        String key = new String(new StringBuilder(sql.length() + 12).append('[').append(autoGeneratedKeys).append(']').append(sql));
        PreparedStatement ps = (PreparedStatement)this.preparedStatementCache.get(key);
        if (ps != null) {
            return ps;
        }
        ps = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql, (int)autoGeneratedKeys);
        this.preparedStatementCache.put(key, ps);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T usingPreparedStatement(String sql, int autoGeneratedKeys, StatementHandler<T, ? super PreparedStatement> handler) {
        String key = new String(new StringBuilder(sql.length() + 12).append('[').append(autoGeneratedKeys).append(']').append(sql));
        PreparedStatement ps = (PreparedStatement)this.preparedStatementCache.remove(key);
        if (ps == null) {
            ps = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql, (int)autoGeneratedKeys);
        }
        try {
            T t = handler.handle(ps);
            return t;
        }
        finally {
            this.preparedStatementCache.put(key, ps);
        }
    }

    @Override
    public PreparedStatement getCursorPreparedStatement(String sql) {
        PreparedStatement ps = (PreparedStatement)this.cursorPreparedStatementCache.get(sql);
        if (ps != null) {
            return ps;
        }
        ps = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql, (int)1004, (int)1007);
        this.cursorPreparedStatementCache.put(sql, ps);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T usingCursorPreparedStatement(String sql, StatementHandler<T, ? super PreparedStatement> handler) {
        PreparedStatement ps = (PreparedStatement)this.cursorPreparedStatementCache.remove(sql);
        if (ps == null) {
            ps = ConnectionUtil.prepareStatement((Connection)this.connection, (String)sql, (int)1004, (int)1007);
        }
        try {
            T t = handler.handle(ps);
            return t;
        }
        finally {
            this.cursorPreparedStatementCache.put(sql, ps);
        }
    }

    @Override
    public CallableStatement getCallableStatement(String sql) {
        CallableStatement cs = (CallableStatement)this.callableStatementCache.get(sql);
        if (cs != null) {
            return cs;
        }
        cs = ConnectionUtil.prepareCall((Connection)this.connection, (String)sql);
        this.callableStatementCache.put(sql, cs);
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T usingCallableStatement(String sql, StatementHandler<T, ? super CallableStatement> handler) {
        CallableStatement cs = (CallableStatement)this.callableStatementCache.remove(sql);
        if (cs == null) {
            cs = ConnectionUtil.prepareCall((Connection)this.connection, (String)sql);
        }
        try {
            T t = handler.handle(cs);
            return t;
        }
        finally {
            this.callableStatementCache.put(sql, cs);
        }
    }

    public boolean idDestroyed() {
        return this.isConnectionNull();
    }

    public boolean isConnectionNull() {
        return this.connection == null;
    }

    public boolean isStatementNull() {
        return this.statement == null;
    }

    public boolean isPreparedStatementCacheEmpty() {
        return this.preparedStatementCache.isEmpty();
    }

    public boolean isCursorPreparedStatementCacheEmpty() {
        return this.cursorPreparedStatementCache.isEmpty();
    }

    public boolean isCallableStatementCacheEmpty() {
        return this.callableStatementCache.isEmpty();
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
        this.preparedStatementCache = new StatementCache(preparedStatementCacheSize);
    }

    public int getCursorPreparedStatementCacheSize() {
        return this.cursorPreparedStatementCacheSize;
    }

    public void setCursorPreparedStatementCacheSize(int cursorPreparedStatementCacheSize) {
        this.cursorPreparedStatementCacheSize = cursorPreparedStatementCacheSize;
        this.cursorPreparedStatementCache = new StatementCache(cursorPreparedStatementCacheSize);
    }

    public int getCallableStatementCacheSize() {
        return this.callableStatementCacheSize;
    }

    public void setCallableStatementCacheSize(int callableStatementCacheSize) {
        this.callableStatementCacheSize = callableStatementCacheSize;
        this.callableStatementCache = new StatementCache(callableStatementCacheSize);
    }
}

