/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class BoolPtg
extends ScalarConstantPtg {
    public static final int SIZE = 2;
    public static final byte sid = 29;
    private final boolean _value;

    public BoolPtg(LittleEndianInput in) {
        this._value = in.readByte() == 1;
    }

    public BoolPtg(String formulaToken) {
        this._value = formulaToken.equalsIgnoreCase("TRUE");
    }

    public boolean getValue() {
        return this._value;
    }

    public void write(LittleEndianOutput out) {
        out.writeByte(29 + this.getPtgClass());
        out.writeByte(this._value ? 1 : 0);
    }

    public int getSize() {
        return 2;
    }

    public String toFormulaString() {
        return this._value ? "TRUE" : "FALSE";
    }
}

