/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class ForwardCompatibilityTest
extends TestCase {
    static String fLog;
    static Exception exception;
    static String log;
    private static boolean wasRun;

    public void testCompatibility() {
        fLog = "";
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(NewTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertEquals("before test after ", fLog);
    }

    public void testToString() {
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(NewTest.class);
        junit.framework.Test test = adapter.getTests().get(0);
        ForwardCompatibilityTest.assertEquals(String.format("test(%s)", NewTest.class.getName()), test.toString());
    }

    public void testUseGlobalCache() {
        JUnit4TestAdapter adapter1 = new JUnit4TestAdapter(NewTest.class);
        JUnit4TestAdapter adapter2 = new JUnit4TestAdapter(NewTest.class);
        ForwardCompatibilityTest.assertSame(adapter1.getTests().get(0), adapter2.getTests().get(0));
    }

    public void testException() {
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(ErrorTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertEquals(exception, result.errors().nextElement().thrownException());
    }

    public void testNotifyResult() {
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(ErrorTest.class);
        TestResult result = new TestResult();
        final StringBuffer log = new StringBuffer();
        result.addListener(new TestListener(){

            public void startTest(junit.framework.Test test) {
                log.append(" start " + test);
            }

            public void endTest(junit.framework.Test test) {
                log.append(" end " + test);
            }

            public void addFailure(junit.framework.Test test, AssertionFailedError t) {
                log.append(" failure " + test);
            }

            public void addError(junit.framework.Test test, Throwable t) {
                log.append(" error " + test);
            }
        });
        adapter.run(result);
        String testName = String.format("error(%s)", ErrorTest.class.getName());
        ForwardCompatibilityTest.assertEquals(String.format(" start %s error %s end %s", testName, testName, testName), log.toString());
    }

    public void testNoException() {
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(NoExceptionTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertFalse(result.wasSuccessful());
    }

    public void testExpected() {
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(ExpectedTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertTrue(result.wasSuccessful());
    }

    public void testBeforeAndAfterClass() {
        log = "";
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(BeforeClassTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertEquals("before class before test after before test after after class ", log);
    }

    public void testExceptionInBefore() {
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(ExceptionInBeforeTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertEquals(1, result.errorCount());
    }

    public void testInvalidMethod() {
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(InvalidMethodTest.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertEquals(1, result.errorCount());
        TestFailure failure = result.errors().nextElement();
        ForwardCompatibilityTest.assertTrue(failure.exceptionMessage().contains("Method shouldBeStatic() should be static"));
    }

    public void testRunWithClass() {
        wasRun = false;
        TestResult result = new TestResult();
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(NoTests.class);
        adapter.run(result);
        ForwardCompatibilityTest.assertTrue(wasRun);
    }

    public void testToStringSuite() {
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(NoTests.class);
        ForwardCompatibilityTest.assertEquals(NoTests.class.getName(), ((Object)adapter).toString());
    }

    static {
        exception = new Exception();
        wasRun = false;
    }

    @RunWith(value=MarkerRunner.class)
    public static class NoTests {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarkerRunner
    extends Runner {
        public MarkerRunner(Class<?> klass) {
        }

        @Override
        public void run(RunNotifier notifier) {
            wasRun = true;
        }

        @Override
        public int testCount() {
            return 0;
        }

        @Override
        public Description getDescription() {
            return Description.EMPTY;
        }
    }

    public static class InvalidMethodTest {
        @BeforeClass
        public void shouldBeStatic() {
        }
    }

    public static class ExceptionInBeforeTest {
        @Before
        public void error() {
            throw new Error();
        }

        @Test
        public void nothing() {
        }
    }

    public static class BeforeClassTest {
        @BeforeClass
        public static void beforeClass() {
            log = log + "before class ";
        }

        @Before
        public void before() {
            log = log + "before ";
        }

        @Test
        public void one() {
            log = log + "test ";
        }

        @Test
        public void two() {
            log = log + "test ";
        }

        @After
        public void after() {
            log = log + "after ";
        }

        @AfterClass
        public static void afterClass() {
            log = log + "after class ";
        }
    }

    public static class UnExpectedExceptionTest {
        @Test(expected=Exception.class)
        public void expected() throws Exception {
            throw new Error();
        }
    }

    public static class ExpectedTest {
        @Test(expected=Exception.class)
        public void expected() throws Exception {
            throw new Exception();
        }
    }

    public static class NoExceptionTest {
        @Test(expected=Exception.class)
        public void succeed() throws Exception {
        }
    }

    public static class ErrorTest {
        @Test
        public void error() throws Exception {
            throw exception;
        }
    }

    public static class NewTest {
        @Before
        public void before() {
            fLog = fLog + "before ";
        }

        @After
        public void after() {
            fLog = fLog + "after ";
        }

        @Test
        public void test() {
            fLog = fLog + "test ";
        }
    }
}

