/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.analytics.impl;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.mobylet.core.analytics.AnalyticsHelper;
import org.mobylet.core.analytics.AnalyticsParameters;
import org.mobylet.core.analytics.impl.GoogleAnalyticsConfig;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class GoogleAnalyticsProcess
implements Runnable {
    protected AnalyticsParameters parameters;

    public GoogleAnalyticsProcess(AnalyticsParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public void run() {
        GoogleAnalyticsConfig config = SingletonUtils.get(GoogleAnalyticsConfig.class);
        AnalyticsHelper helper = SingletonUtils.get(AnalyticsHelper.class);
        String url = helper.getURL(this.parameters);
        if (StringUtils.isEmpty(url)) {
            return;
        }
        HttpURLConnection connection = HttpUtils.getHttpUrlConnection(url);
        connection.setRequestProperty("User-Agent", this.parameters.getCarrier().name());
        connection.setRequestProperty("Accept-Language", this.parameters.getUseLanguage());
        connection.setConnectTimeout(config.getConnectionTimeout());
        try {
            connection.connect();
            connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

