/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image;

import java.io.File;
import java.util.regex.Pattern;
import org.mobylet.core.config.MobyletInjectionConfig;
import org.mobylet.core.image.ImageSourceType;
import org.mobylet.core.image.ScaleType;
import org.mobylet.core.util.StringUtils;

public class ImageConfig
extends MobyletInjectionConfig {
    public static final String PKEY_IMGPATH = "img";
    public static final String PKEY_AUTOSCALE = "autoScale";
    public static final String PKEY_SCALETYPE = "scaleType";
    public static final String PVAL_AUTOSCALE = "on";
    public static final String PKEY_WIDTH = "w";
    public static final String CONFIG_KEY_IMAGE_SOURCE = "image.source.type";
    public static final String CONFIG_KEY_LOCAL_BASE_DIR = "image.local.base.dir";
    public static final String CONFIG_KEY_CACHE_BASE_DIR = "image.cache.base.dir";
    public static final String CONFIG_KEY_SCALE_SERVLET_PATH = "image.scale.servlet.path";
    public static final String CONFIG_KEY_DEFAULT_SCALETYPE = "image.default.scaletype";
    public static final String CONFIG_KEY_DEFAULT_SCALE_IMAGE_WIDTH = "image.default.scale.image.width";
    public static final String CONFIG_KEY_IMAGE_SOURCE_ALLOW_URL = "image.source.url.allow";
    public static final String CONFIG_KEY_IMAGE_SOURCE_NETWORK_LIMIT_SIZE = "image.source.network.limit.size";
    public static final String CONFIG_KEY_IMAGE_SOURCE_LOCAL_LIMIT_SIZE = "image.source.local.limit.size";
    public static final String CONFIG_KEY_USE_IMAGEMAGICK = "imagemagick.use";
    public static final String CONFIG_KEY_IMAGEMAGICK_PATH = "imagemagick.path";
    public static final String CONFIG_KEY_IMAGEMAGICK_WORKDIR = "imagemagick.workdir";
    protected ScaleType defScaleType;
    protected ImageSourceType imageSourceType;
    protected boolean isInitializedAllowUrlRegex = false;
    protected Pattern allowUrlRegex;
    protected Integer networkLimitSize;
    protected Integer localLimitSize;
    protected String imageMagickPath;
    protected String imageMagickWorkDir;

    public ImageSourceType getImageSourceType() {
        if (this.imageSourceType == null) {
            try {
                this.imageSourceType = ImageSourceType.valueOf(this.getConfig().getProperty(CONFIG_KEY_IMAGE_SOURCE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.imageSourceType == null) {
                this.imageSourceType = ImageSourceType.DEFAULT;
            }
        }
        return this.imageSourceType;
    }

    public Pattern getAllowUrlRegex() {
        if (!this.isInitializedAllowUrlRegex) {
            try {
                String urlRegex = this.getConfig().getProperty(CONFIG_KEY_IMAGE_SOURCE_ALLOW_URL);
                if (StringUtils.isNotEmpty(urlRegex)) {
                    this.allowUrlRegex = Pattern.compile(urlRegex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isInitializedAllowUrlRegex = true;
        }
        return this.allowUrlRegex;
    }

    public String getLocalBaseDirPath() {
        return this.getConfig().getProperty(CONFIG_KEY_LOCAL_BASE_DIR);
    }

    public String getCacheBaseDirPath() {
        return this.getConfig().getProperty(CONFIG_KEY_CACHE_BASE_DIR);
    }

    public boolean useScaleServlet() {
        return StringUtils.isNotEmpty(this.getScaleServletPath());
    }

    public String getScaleServletPath() {
        return this.getConfig().getProperty(CONFIG_KEY_SCALE_SERVLET_PATH);
    }

    public ScaleType getDefaultScaleType() {
        if (this.defScaleType == null) {
            String scaleTypeStr = this.getConfig().getProperty(CONFIG_KEY_DEFAULT_SCALETYPE);
            if (StringUtils.isNotEmpty(scaleTypeStr)) {
                this.defScaleType = ScaleType.valueOf(scaleTypeStr);
                if (this.defScaleType == null) {
                    this.defScaleType = ScaleType.FITWIDTH;
                }
            } else {
                this.defScaleType = ScaleType.FITWIDTH;
            }
        }
        return this.defScaleType;
    }

    public String getDefaultScaleImageWidth() {
        return this.getConfig().getProperty(CONFIG_KEY_DEFAULT_SCALE_IMAGE_WIDTH);
    }

    public Integer getNetworkLimitSize() {
        if (this.networkLimitSize == null) {
            try {
                this.networkLimitSize = Integer.parseInt(this.getConfig().getProperty(CONFIG_KEY_IMAGE_SOURCE_NETWORK_LIMIT_SIZE));
            }
            catch (Exception e) {
                this.networkLimitSize = 0;
            }
        }
        return this.networkLimitSize;
    }

    public Integer getLocalLimitSize() {
        if (this.localLimitSize == null) {
            try {
                this.localLimitSize = Integer.parseInt(this.getConfig().getProperty(CONFIG_KEY_IMAGE_SOURCE_LOCAL_LIMIT_SIZE));
            }
            catch (Exception e) {
                this.localLimitSize = 0;
            }
        }
        return this.localLimitSize;
    }

    public boolean useImageMagick() {
        String useImageMagick = this.getConfig().getProperty(CONFIG_KEY_USE_IMAGEMAGICK);
        return "true".equalsIgnoreCase(useImageMagick);
    }

    public String getImageMagickPath() {
        if (this.imageMagickPath == null) {
            this.imageMagickPath = this.getConfig().getProperty(CONFIG_KEY_IMAGEMAGICK_PATH);
            if (StringUtils.isEmpty(this.imageMagickPath)) {
                this.imageMagickPath = "";
            } else if (!this.imageMagickPath.endsWith(File.separator)) {
                this.imageMagickPath = this.imageMagickPath + File.separator;
            }
        }
        return this.imageMagickPath;
    }

    public String getImageMagickWorkDir() {
        if (this.imageMagickWorkDir == null) {
            this.imageMagickWorkDir = this.getConfig().getProperty(CONFIG_KEY_IMAGEMAGICK_WORKDIR);
            if (StringUtils.isEmpty(this.imageMagickWorkDir)) {
                this.imageMagickWorkDir = "/tmp/mobylet/work/imagemagick/";
                new File(this.imageMagickWorkDir).mkdirs();
            } else if (!this.imageMagickWorkDir.endsWith(File.separator)) {
                this.imageMagickWorkDir = this.imageMagickWorkDir + File.separator;
            }
        }
        return this.imageMagickWorkDir;
    }

    @Override
    public String getConfigName() {
        return "mobylet.image.properties";
    }
}

