/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtils {
    public static boolean parseSax(String path, DefaultHandler handler) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        InputStream xmlStream = null;
        try {
            xmlStream = ResourceUtils.getResourceFileOrInputStream(path);
            return XmlUtils.parseSax(xmlStream, handler);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("XML\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u4f8b\u5916\u767a\u751f [" + path + "]", e);
        }
    }

    public static boolean parseSax(InputStream inputStream, DefaultHandler handler) {
        try {
            if (inputStream != null) {
                SAXParserFactory spfactory = SAXParserFactory.newInstance();
                SAXParser parser = spfactory.newSAXParser();
                parser.parse(inputStream, handler);
                boolean bl = true;
                return bl;
            }
            boolean spfactory = false;
            return spfactory;
        }
        catch (ParserConfigurationException e) {
            throw new MobyletRuntimeException("\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", e);
        }
        catch (SAXException e) {
            throw new MobyletRuntimeException("SAX\u30d1\u30fc\u30b9\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        finally {
            InputStreamUtils.closeQuietly(inputStream);
        }
    }

    public static boolean parseSax(InputSource inputSource, DefaultHandler handler) {
        try {
            if (inputSource != null) {
                SAXParserFactory spfactory = SAXParserFactory.newInstance();
                SAXParser parser = spfactory.newSAXParser();
                parser.parse(inputSource, handler);
                return true;
            }
            return false;
        }
        catch (ParserConfigurationException e) {
            throw new MobyletRuntimeException("\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", e);
        }
        catch (SAXException e) {
            throw new MobyletRuntimeException("SAX\u30d1\u30fc\u30b9\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

