/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.css;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.view.css.CSSCond;
import org.mobylet.view.css.CSSCondContainer;
import org.mobylet.view.css.SelectorType;

public class CSSParser {
    public CSSCondContainer parse(InputStream in) {
        CSSCondContainer container = new CSSCondContainer();
        if (in == null) {
            return container;
        }
        CharArrayWriter chars = new CharArrayWriter(128);
        String key = null;
        String value = null;
        boolean isComment = false;
        int c = 0;
        int pre = 0;
        try {
            while ((c = in.read()) != -1) {
                switch (c) {
                    case 47: {
                        if (isComment && pre == 42) {
                            isComment = false;
                            break;
                        }
                        if (isComment) break;
                        chars.append((char)c);
                        break;
                    }
                    case 42: {
                        if (!isComment && pre == 47) {
                            isComment = true;
                            break;
                        }
                        if (isComment) break;
                        chars.append((char)c);
                        break;
                    }
                    case 123: {
                        if (isComment) break;
                        key = new String(chars.toCharArray()).trim();
                        chars.reset();
                        break;
                    }
                    case 125: {
                        String[] csvKeys;
                        if (isComment) break;
                        value = new String(chars.toCharArray()).trim();
                        chars.reset();
                        for (String csvKey : csvKeys = key.split("[,]")) {
                            String[] singleKeys = csvKey.split("\\s");
                            CSSCond p = null;
                            boolean isNextFirstChild = false;
                            for (String singleKey : singleKeys) {
                                if (singleKey.contains(">")) {
                                    CSSCond cond;
                                    String[] directKeys = singleKey.split("[>]");
                                    if (directKeys.length == 0) {
                                        isNextFirstChild = true;
                                        continue;
                                    }
                                    if (directKeys.length == 2 && singleKey.startsWith(">")) {
                                        cond = new CSSCond(directKeys[1].trim());
                                        if (cond.getSelectorType() != SelectorType.FIRST_CHILD) {
                                            cond.setSelectorType(SelectorType.CHILD);
                                        }
                                        if (p != null) {
                                            cond.setParent(p);
                                        }
                                        p = cond;
                                    } else {
                                        if (directKeys.length == 2 && singleKey.endsWith(">")) {
                                            cond = new CSSCond(directKeys[0].trim());
                                            if (p != null) {
                                                cond.setParent(p);
                                            }
                                            p = cond;
                                            isNextFirstChild = true;
                                            continue;
                                        }
                                        for (int i = 0; i < directKeys.length; ++i) {
                                            CSSCond cond2 = new CSSCond(directKeys[i].trim());
                                            if (i > 0 && cond2.getSelectorType() != SelectorType.FIRST_CHILD) {
                                                cond2.setSelectorType(SelectorType.CHILD);
                                            }
                                            if (p != null) {
                                                cond2.setParent(p);
                                            }
                                            p = cond2;
                                        }
                                    }
                                } else {
                                    CSSCond cond = new CSSCond(singleKey.trim());
                                    if (p != null) {
                                        cond.setParent(p);
                                    }
                                    p = cond;
                                }
                                if (!isNextFirstChild || p.getSelectorType() == SelectorType.FIRST_CHILD) continue;
                                p.setSelectorType(SelectorType.CHILD);
                            }
                            String[] entries = value.split("[;]");
                            if (entries != null && entries.length > 0) {
                                for (String entry : entries) {
                                    int di = entry.indexOf(58);
                                    if (di <= 0) continue;
                                    p.putStyle(entry.substring(0, di), entry.substring(di + 1));
                                }
                            }
                            container.put(p);
                        }
                        break;
                    }
                    default: {
                        if (isComment) break;
                        chars.append((char)c);
                    }
                }
                pre = c;
            }
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("CSS\u8aad\u307f\u8fbc\u307f\u4e2d\u306bIO\u4f8b\u5916\u304c\u767a\u751f", e);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("CSS\u304c\u6b63\u3057\u304f\u8aad\u3081\u307e\u305b\u3093", e);
        }
        return container;
    }
}

