/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.seasar.robot.db.cbean.UrlFilterCB;
import org.seasar.robot.db.exbhv.UrlFilterBhv;
import org.seasar.robot.db.exentity.UrlFilter;
import org.seasar.robot.dbflute.cbean.ListResultBean;
import org.seasar.robot.service.UrlFilterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUrlFilterServiceImpl
implements UrlFilterService {
    private static final String INCLUDE_FILTER_TYPE = "I";
    private static final String EXCLUDE_FILTER_TYPE = "E";
    @Resource
    protected UrlFilterBhv urlFilterBhv;

    public void addIncludeUrlFilter(String sessionId, String url) {
        this.addUrlFilter(sessionId, url, INCLUDE_FILTER_TYPE);
    }

    public void addIncludeUrlFilter(String sessionId, List<String> urlList) {
        this.addUrlFilter(sessionId, urlList, INCLUDE_FILTER_TYPE);
    }

    public void addExcludeUrlFilter(String sessionId, String url) {
        this.addUrlFilter(sessionId, url, EXCLUDE_FILTER_TYPE);
    }

    public void addExcludeUrlFilter(String sessionId, List<String> urlList) {
        this.addUrlFilter(sessionId, urlList, EXCLUDE_FILTER_TYPE);
    }

    private void addUrlFilter(String sessionId, String url, String filterType) {
        UrlFilter urlFilter = new UrlFilter();
        urlFilter.setSessionId(sessionId);
        urlFilter.setUrl(url);
        urlFilter.setFilterType(filterType);
        urlFilter.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.urlFilterBhv.insert(urlFilter);
    }

    private void addUrlFilter(String sessionId, List<String> urlList, String filterType) {
        ArrayList<UrlFilter> urlFilterList = new ArrayList<UrlFilter>();
        for (String url : urlList) {
            UrlFilter urlFilter = new UrlFilter();
            urlFilter.setSessionId(sessionId);
            urlFilter.setUrl(url);
            urlFilter.setFilterType(filterType);
            urlFilter.setCreateTime(new Timestamp(System.currentTimeMillis()));
            urlFilterList.add(urlFilter);
        }
        this.urlFilterBhv.batchInsert(urlFilterList);
    }

    public void delete(String sessionId) {
        this.urlFilterBhv.deleteBySessionId(sessionId);
    }

    public void deleteAll() {
        this.urlFilterBhv.deleteAll();
    }

    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        return this.getUrlPatternList(sessionId, INCLUDE_FILTER_TYPE);
    }

    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        return this.getUrlPatternList(sessionId, EXCLUDE_FILTER_TYPE);
    }

    private List<Pattern> getUrlPatternList(String sessionId, String filterType) {
        UrlFilterCB cb = new UrlFilterCB();
        cb.query().setSessionId_Equal(sessionId);
        cb.query().setFilterType_Equal(filterType);
        ListResultBean urlFilterList = this.urlFilterBhv.selectList(cb);
        ArrayList<Pattern> urlPatternList = new ArrayList<Pattern>();
        for (UrlFilter urlFilter : urlFilterList) {
            urlPatternList.add(Pattern.compile(urlFilter.getUrl()));
        }
        return urlPatternList;
    }
}

