/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.schedule;

import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.impl.TaskStateType;
import org.seasar.chronos.core.schedule.ScheduleEntry;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScheduleEntryManager {
    private static Logger log = Logger.getLogger(TaskScheduleEntryManager.class);
    private static TaskScheduleEntryManager instance;
    private final ConcurrentHashMap<TaskStateType, CopyOnWriteArrayList<TaskScheduleEntry>> taskScheduleEntryMap = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<TaskScheduleEntry> allTaskList = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<Class<?>, TaskScheduleEntry> taskScheduleEntryClassMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskScheduleEntryManager getInstance() {
        if (instance != null) return instance;
        Class<TaskScheduleEntryManager> clazz = TaskScheduleEntryManager.class;
        synchronized (TaskScheduleEntryManager.class) {
            if (instance != null) return instance;
            instance = new TaskScheduleEntryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TaskScheduleEntryManager() {
    }

    public boolean addTaskScheduleEntry(TaskStateType key, TaskScheduleEntry taskScheduleEntry) {
        taskScheduleEntry.setTaskStateType(key);
        boolean result = this.getScheduleEntryList(key).add(taskScheduleEntry);
        if (key == TaskStateType.SCHEDULED) {
            result = result && this.allTaskList.addIfAbsent(taskScheduleEntry);
            Class<?> taskComponentClass = taskScheduleEntry.getTaskClass();
            if (!this.taskScheduleEntryClassMap.containsKey(taskComponentClass)) {
                this.taskScheduleEntryClassMap.put(taskComponentClass, taskScheduleEntry);
            } else {
                result = false;
            }
        } else if (key == TaskStateType.UNSCHEDULED) {
            taskScheduleEntry.setUnScheduledDate(Calendar.getInstance().getTime());
        }
        return result;
    }

    public void allRemove(TaskStateType key) {
        this.getScheduleEntryList(key).clear();
    }

    public boolean contains(Object key) {
        if (key instanceof ScheduleEntry) {
            return this.allTaskList.contains(key);
        }
        return this.taskScheduleEntryClassMap.containsKey(key);
    }

    public boolean contains(TaskStateType key, TaskScheduleEntry taskContena) {
        CopyOnWriteArrayList<TaskScheduleEntry> result = this.taskScheduleEntryMap.get((Object)key);
        if (result != null) {
            return result.contains(taskContena);
        }
        return false;
    }

    public Object forEach(TaskScheduleEntryHanlder handler) {
        for (TaskScheduleEntry tse : this.allTaskList) {
            Object result = handler.processTaskScheduleEntry(tse);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object forEach(TaskStateType key, TaskScheduleEntryHanlder handler) {
        CopyOnWriteArrayList<TaskScheduleEntry> scheduleEntryList = this.getScheduleEntryList(key);
        for (TaskScheduleEntry tse : scheduleEntryList) {
            Object result = handler.processTaskScheduleEntry(tse);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private CopyOnWriteArrayList<TaskScheduleEntry> getScheduleEntryList(TaskStateType key) {
        CopyOnWriteArrayList<TaskScheduleEntry> result = this.taskScheduleEntryMap.get((Object)key);
        if (result == null) {
            result = new CopyOnWriteArrayList();
            this.taskScheduleEntryMap.put(key, result);
        }
        return result;
    }

    public TaskScheduleEntry getTaskScheduleEntry(Object key) {
        return this.taskScheduleEntryClassMap.get(key);
    }

    public boolean removeTaskScheduleEntry(TaskScheduleEntry taskScheduleEntry) {
        boolean result = this.allTaskList.remove(taskScheduleEntry);
        if (result) {
            for (TaskStateType key : this.taskScheduleEntryMap.keySet()) {
                CopyOnWriteArrayList<TaskScheduleEntry> taskScheduleEntryList = this.taskScheduleEntryMap.get((Object)key);
                if (taskScheduleEntryList == null) continue;
                result = taskScheduleEntryList.remove(taskScheduleEntry);
            }
            Class<?> taskComponentClass = taskScheduleEntry.getTaskClass();
            if (taskComponentClass != null) {
                this.taskScheduleEntryClassMap.remove(taskComponentClass);
            }
        }
        return result;
    }

    public boolean removeTaskScheduleEntry(TaskStateType key, TaskScheduleEntry taskScheduleEntry) {
        boolean result = false;
        result = this.getScheduleEntryList(key).remove(taskScheduleEntry);
        if (key == TaskStateType.UNSCHEDULED) {
            result &= this.allTaskList.remove(taskScheduleEntry);
            result &= this.taskScheduleEntryClassMap.remove(taskScheduleEntry.getComponentDef().getComponentClass()) != null;
        }
        taskScheduleEntry = null;
        return result;
    }

    public int size() {
        return this.allTaskList.size();
    }

    public int size(TaskStateType key) {
        List list = this.taskScheduleEntryMap.get((Object)key);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public static interface TaskScheduleEntryHanlder {
        public Object processTaskScheduleEntry(TaskScheduleEntry var1);
    }
}

