/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.RobotsTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotsTxtHelper {
    protected static final Pattern USER_AGENT = Pattern.compile("^User-agent:\\s*([^\\s]+)\\s*$");
    protected static final Pattern DISALLOW = Pattern.compile("^Disallow:\\s*([^\\s]*)\\s*$");
    protected static final Pattern ALLOW = Pattern.compile("^Allow:\\s*([^\\s]*)\\s*$");
    protected static final Pattern CRAWL_DELAY = Pattern.compile("^Crawl-delay:\\s*([^\\s]+)\\s*$");

    public RobotsTxt parse(String text) {
        String[] lines = text.split("(\\r\\n)|\\r|\\n");
        return this.parse(Arrays.asList(lines));
    }

    public RobotsTxt parse(InputStream stream) {
        return this.parse(stream, "UTF-8");
    }

    public RobotsTxt parse(InputStream stream, String charsetName) {
        try {
            return this.parse(new InputStreamReader(stream, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotSystemException(e);
        }
    }

    public RobotsTxt parse(Reader reader) {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            return this.parse(lines);
        }
        catch (IOException e) {
            throw new RobotSystemException("Could not read from Reader.", e);
        }
    }

    protected RobotsTxt parse(List<String> lines) {
        RobotsTxt robotsTxt = new RobotsTxt();
        RobotsTxt.Directives currentDirectives = null;
        for (String line : lines) {
            line = this.stripComment(line);
            if (StringUtil.isEmpty((String)(line = line.trim()))) continue;
            String value = this.getValue(USER_AGENT, line);
            if (value != null) {
                String userAgent = value.toLowerCase();
                currentDirectives = robotsTxt.getDirectives(userAgent, null);
                if (currentDirectives != null) continue;
                currentDirectives = new RobotsTxt.Directives();
                robotsTxt.addDirectives(userAgent, currentDirectives);
                continue;
            }
            value = this.getValue(DISALLOW, line);
            if (value != null) {
                if (currentDirectives == null || value.length() <= 0) continue;
                currentDirectives.addDisallow(value);
                continue;
            }
            value = this.getValue(ALLOW, line);
            if (value != null) {
                if (currentDirectives == null) continue;
                currentDirectives.addAllow(value);
                continue;
            }
            value = this.getValue(CRAWL_DELAY, line);
            if (value == null || currentDirectives == null) continue;
            try {
                currentDirectives.setCrawlDelay(Math.max(0, Integer.parseInt(value)));
            }
            catch (NumberFormatException e) {}
        }
        return robotsTxt;
    }

    protected String getValue(Pattern pattern, String line) {
        Matcher m = pattern.matcher(line);
        if (m.matches() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    protected String stripComment(String line) {
        int commentIndex = line.indexOf(35);
        if (commentIndex != -1) {
            return line.substring(0, commentIndex);
        }
        return line;
    }
}

