/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.session;

import java.util.HashMap;
import org.mobylet.core.session.MobyletSessionTouchListener;

public class MobyletSession {
    protected String uid;
    protected Long touchTime;
    protected HashMap<Class<? extends Object>, Object> objectMap;
    protected MobyletSessionTouchListener listener;

    public MobyletSession(String uid) {
        this.uid = uid;
        this.objectMap = new HashMap();
        this.touch();
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getTouchTime() {
        return this.touchTime;
    }

    public void setTouchListener(MobyletSessionTouchListener listener) {
        this.listener = listener;
    }

    public <T> void put(T object) {
        if (object == null) {
            return;
        }
        this.touch();
        this.objectMap.put(object.getClass(), object);
    }

    public <T> T get(Class<T> key) {
        if (key == null) {
            return null;
        }
        this.touch();
        return (T)this.objectMap.get(key);
    }

    public <T> T remove(Class<T> key) {
        if (key == null) {
            return null;
        }
        this.touch();
        return (T)this.objectMap.remove(key);
    }

    public void touch() {
        this.touchTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.actionTouch(this);
        }
    }
}

