/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.seasar.extension.dbcp.impl.XAConnectionImpl;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.DriverManagerUtil;
import org.seasar.framework.util.StringUtil;

public class XADataSourceImpl
implements XADataSource {
    private Logger logger = Logger.getLogger((Class)XADataSourceImpl.class);
    private String driverClassName;
    private String url;
    private String user;
    private String password;
    private Properties properties = new Properties();
    private int loginTimeout;

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        if (driverClassName != null && driverClassName.length() > 0) {
            DriverManagerUtil.registerDriver((String)driverClassName);
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.user, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        XAConnectionImpl xAConnectionImpl;
        Properties info = new Properties();
        info.putAll((Map<?, ?>)this.properties);
        if (StringUtil.isNotEmpty((String)user)) {
            info.put("user", user);
        }
        if (StringUtil.isNotEmpty((String)password)) {
            info.put("password", password);
        }
        int currentLoginTimeout = DriverManager.getLoginTimeout();
        try {
            DriverManager.setLoginTimeout(this.loginTimeout);
            Connection con = DriverManager.getConnection(this.url, info);
            xAConnectionImpl = new XAConnectionImpl(con);
        }
        catch (Throwable throwable) {
            try {
                DriverManager.setLoginTimeout(currentLoginTimeout);
            }
            catch (Exception e) {
                this.logger.log("ESSR0017", new Object[]{e.toString()}, (Throwable)e);
            }
            throw throwable;
        }
        try {
            DriverManager.setLoginTimeout(currentLoginTimeout);
        }
        catch (Exception e) {
            this.logger.log("ESSR0017", new Object[]{e.toString()}, (Throwable)e);
        }
        return xAConnectionImpl;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }
}

