/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.core.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandComponentSetup;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.s2dao.extension.TnRelationRowCreatorExtension;
import org.seasar.robot.dbflute.s2dao.extension.TnRowCreatorExtension;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.robot.dbflute.s2dao.rshandler.TnBeanCursorMetaDataResultSetHandler;
import org.seasar.robot.dbflute.s2dao.rshandler.TnBeanListMetaDataResultSetHandler;
import org.seasar.robot.dbflute.s2dao.sqlcommand.TnUpdateDynamicCommand;
import org.seasar.robot.dbflute.s2dao.valuetype.TnValueTypeFactory;
import org.seasar.robot.dbflute.s2dao.valuetype.TnValueTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorCommand<RESULT>
implements BehaviorCommand<RESULT>,
BehaviorCommandComponentSetup {
    protected String _tableDbName;
    protected boolean _initializeOnly;
    protected DataSource _dataSource;
    protected StatementFactory _statementFactory;
    protected TnBeanMetaDataFactory _beanMetaDataFactory;
    protected TnValueTypeFactory _valueTypeFactory;
    protected String _sqlFileEncoding;

    protected TnUpdateDynamicCommand createUpdateDynamicCommand(String[] argNames, Class<?>[] argTypes, String sql) {
        TnUpdateDynamicCommand cmd = new TnUpdateDynamicCommand(this._dataSource, this._statementFactory);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(argTypes);
        if (sql != null) {
            cmd.setSql(sql);
        }
        return cmd;
    }

    protected TnResultSetHandler createBeanListMetaDataResultSetHandler(TnBeanMetaData bmd) {
        TnRowCreatorExtension rowCreator = this.createInternalRowCreator(bmd);
        TnRelationRowCreatorExtension relationRowCreator = this.createInternalRelationRowCreator(bmd);
        return new TnBeanListMetaDataResultSetHandler(bmd, rowCreator, relationRowCreator);
    }

    protected TnResultSetHandler createBeanCursorMetaDataResultSetHandler(TnBeanMetaData bmd) {
        TnRowCreatorExtension rowCreator = this.createInternalRowCreator(bmd);
        TnRelationRowCreatorExtension relationRowCreator = this.createInternalRelationRowCreator(bmd);
        return new TnBeanCursorMetaDataResultSetHandler(bmd, rowCreator, relationRowCreator);
    }

    protected TnResultSetHandler createObjectResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return new InternalObjectResultSetHandler(valueType);
    }

    protected TnResultSetHandler createObjectListResultSetHandler(Class<?> objectType) {
        ValueType valueType = TnValueTypes.getValueType(objectType);
        return this.createObjectListResultSetHandler(valueType);
    }

    protected TnResultSetHandler createObjectListResultSetHandler(ValueType valueType) {
        return new InternalObjectListResultSetHandler(valueType);
    }

    protected TnRowCreatorExtension createInternalRowCreator(TnBeanMetaData bmd) {
        Class<?> clazz = bmd != null ? bmd.getBeanClass() : null;
        return TnRowCreatorExtension.createRowCreator(clazz);
    }

    protected TnRelationRowCreatorExtension createInternalRelationRowCreator(TnBeanMetaData bmd) {
        return new TnRelationRowCreatorExtension();
    }

    protected void assertBasicProperty(String methodName) {
        if (this._tableDbName == null) {
            throw new IllegalStateException(this.buildAssertMessage("_tableDbName", methodName));
        }
    }

    protected void assertComponentProperty(String methodName) {
        if (this._dataSource == null) {
            throw new IllegalStateException(this.buildAssertMessage("_dataSource", methodName));
        }
        if (this._statementFactory == null) {
            throw new IllegalStateException(this.buildAssertMessage("_statementFactory", methodName));
        }
        if (this._beanMetaDataFactory == null) {
            throw new IllegalStateException(this.buildAssertMessage("_beanMetaDataFactory", methodName));
        }
        if (this._valueTypeFactory == null) {
            throw new IllegalStateException(this.buildAssertMessage("_valueTypeFactory", methodName));
        }
        if (this._sqlFileEncoding == null) {
            throw new IllegalStateException(this.buildAssertMessage("_sqlFileEncoding", methodName));
        }
    }

    protected String buildAssertMessage(String propertyName, String methodName) {
        propertyName = propertyName.startsWith("_") ? propertyName.substring("_".length()) : propertyName;
        String msg = "The property '" + propertyName + "' should not be null";
        msg = msg + " when you call " + methodName + "().";
        throw new IllegalStateException(msg);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":{" + this.buildSqlExecutionKey() + "}";
    }

    @Override
    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public void setInitializeOnly(boolean initializeOnly) {
        this._initializeOnly = initializeOnly;
    }

    @Override
    public boolean isInitializeOnly() {
        return this._initializeOnly;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    @Override
    public void setStatementFactory(StatementFactory statementFactory) {
        this._statementFactory = statementFactory;
    }

    @Override
    public void setBeanMetaDataFactory(TnBeanMetaDataFactory beanMetaDataFactory) {
        this._beanMetaDataFactory = beanMetaDataFactory;
    }

    @Override
    public void setValueTypeFactory(TnValueTypeFactory valueTypeFactory) {
        this._valueTypeFactory = valueTypeFactory;
    }

    @Override
    public void setSqlFileEncoding(String sqlFileEncoding) {
        this._sqlFileEncoding = sqlFileEncoding;
    }

    protected static class InternalNullResultSetHandler
    implements TnResultSetHandler {
        protected InternalNullResultSetHandler() {
        }

        public Object handle(ResultSet rs) throws SQLException {
            return null;
        }
    }

    protected static class InternalObjectListResultSetHandler
    implements TnResultSetHandler {
        private ValueType valueType;

        public InternalObjectListResultSetHandler(ValueType valueType) {
            this.valueType = valueType;
        }

        public Object handle(ResultSet rs) throws SQLException {
            ArrayList<Object> ret = new ArrayList<Object>();
            while (rs.next()) {
                ret.add(this.valueType.getValue(rs, 1));
            }
            return ret;
        }
    }

    protected static class InternalObjectResultSetHandler
    implements TnResultSetHandler {
        private ValueType valueType;

        public InternalObjectResultSetHandler(ValueType valueType) {
            this.valueType = valueType;
        }

        public Object handle(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return this.valueType.getValue(rs, 1);
            }
            return null;
        }
    }
}

