/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.cache.CacheEntry;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;

@Immutable
public class CachedHttpResponseGenerator {
    HttpResponse generateResponse(CacheEntry entry) {
        long age;
        BasicHttpResponse response = new BasicHttpResponse(CachingHttpClient.HTTP_1_1, entry.getStatusCode(), entry.getReasonPhrase());
        if (entry.getStatusCode() != 304) {
            ByteArrayEntity entity = new ByteArrayEntity(entry.getBody());
            response.setEntity((HttpEntity)entity);
            response.setHeaders(entry.getAllHeaders());
            this.addMissingContentLengthHeader((HttpResponse)response, (HttpEntity)entity);
        }
        if ((age = entry.getCurrentAgeSecs()) > 0L) {
            if (age >= Integer.MAX_VALUE) {
                response.setHeader("Age", "2147483648");
            } else {
                response.setHeader("Age", "" + (int)age);
            }
        }
        return response;
    }

    private void addMissingContentLengthHeader(HttpResponse response, HttpEntity entity) {
        if (this.transferEncodingIsPresent(response)) {
            return;
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength == null) {
            contentLength = new BasicHeader("Content-Length", Long.toString(entity.getContentLength()));
            response.setHeader(contentLength);
        }
    }

    private boolean transferEncodingIsPresent(HttpResponse response) {
        Header hdr = response.getFirstHeader("Transfer-Encoding");
        return hdr != null;
    }
}

