/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.cache.HttpCache;
import org.apache.http.client.cache.HttpCacheOperationException;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.BasicHttpCache;
import org.apache.http.impl.client.cache.CacheEntry;
import org.apache.http.impl.client.cache.CacheEntryGenerator;
import org.apache.http.impl.client.cache.CacheEntryUpdater;
import org.apache.http.impl.client.cache.CacheInvalidator;
import org.apache.http.impl.client.cache.CacheableRequestPolicy;
import org.apache.http.impl.client.cache.CachedHttpResponseGenerator;
import org.apache.http.impl.client.cache.CachedResponseSuitabilityChecker;
import org.apache.http.impl.client.cache.ConditionalRequestBuilder;
import org.apache.http.impl.client.cache.OptionsHttp11Response;
import org.apache.http.impl.client.cache.RequestProtocolCompliance;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.impl.client.cache.ResponseCachingPolicy;
import org.apache.http.impl.client.cache.ResponseProtocolCompliance;
import org.apache.http.impl.client.cache.SizeLimitedResponseReader;
import org.apache.http.impl.client.cache.URIExtractor;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CachingHttpClient
implements HttpClient {
    private static final int MAX_CACHE_ENTRIES = 1000;
    private static final int DEFAULT_MAX_OBJECT_SIZE_BYTES = 8192;
    public static final ProtocolVersion HTTP_1_1 = new ProtocolVersion("HTTP", 1, 1);
    private static final boolean SUPPORTS_RANGE_AND_CONTENT_RANGE_HEADERS = false;
    private final HttpClient backend;
    private final ResponseCachingPolicy responseCachingPolicy;
    private final CacheEntryGenerator cacheEntryGenerator;
    private final URIExtractor uriExtractor;
    private final HttpCache<CacheEntry> responseCache;
    private final CachedHttpResponseGenerator responseGenerator;
    private final CacheInvalidator cacheInvalidator;
    private final CacheableRequestPolicy cacheableRequestPolicy;
    private final CachedResponseSuitabilityChecker suitabilityChecker;
    private final ConditionalRequestBuilder conditionalRequestBuilder;
    private final int maxObjectSizeBytes;
    private final CacheEntryUpdater cacheEntryUpdater;
    private AtomicLong cacheHits = new AtomicLong();
    private AtomicLong cacheMisses = new AtomicLong();
    private AtomicLong cacheUpdates = new AtomicLong();
    private final ResponseProtocolCompliance responseCompliance;
    private final RequestProtocolCompliance requestCompliance;
    private final Log log = LogFactory.getLog(this.getClass());

    public CachingHttpClient() {
        this.backend = new DefaultHttpClient();
        this.maxObjectSizeBytes = 8192;
        this.responseCachingPolicy = new ResponseCachingPolicy(this.maxObjectSizeBytes);
        this.cacheEntryGenerator = new CacheEntryGenerator();
        this.uriExtractor = new URIExtractor();
        this.responseCache = new BasicHttpCache(1000);
        this.responseGenerator = new CachedHttpResponseGenerator();
        this.cacheInvalidator = new CacheInvalidator(this.uriExtractor, this.responseCache);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker();
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.cacheEntryUpdater = new CacheEntryUpdater();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance();
    }

    public CachingHttpClient(HttpCache<CacheEntry> cache, int maxObjectSizeBytes) {
        this.responseCache = cache;
        this.backend = new DefaultHttpClient();
        this.maxObjectSizeBytes = maxObjectSizeBytes;
        this.responseCachingPolicy = new ResponseCachingPolicy(maxObjectSizeBytes);
        this.cacheEntryGenerator = new CacheEntryGenerator();
        this.uriExtractor = new URIExtractor();
        this.responseGenerator = new CachedHttpResponseGenerator();
        this.cacheInvalidator = new CacheInvalidator(this.uriExtractor, this.responseCache);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker();
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.cacheEntryUpdater = new CacheEntryUpdater();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance();
    }

    public CachingHttpClient(HttpClient client, HttpCache<CacheEntry> cache, int maxObjectSizeBytes) {
        this.responseCache = cache;
        this.backend = client;
        this.responseCachingPolicy = new ResponseCachingPolicy(maxObjectSizeBytes);
        this.cacheEntryGenerator = new CacheEntryGenerator();
        this.uriExtractor = new URIExtractor();
        this.responseGenerator = new CachedHttpResponseGenerator();
        this.cacheInvalidator = new CacheInvalidator(this.uriExtractor, this.responseCache);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker();
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.cacheEntryUpdater = new CacheEntryUpdater();
        this.maxObjectSizeBytes = maxObjectSizeBytes;
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance();
    }

    public CachingHttpClient(HttpClient backend, ResponseCachingPolicy responseCachingPolicy, CacheEntryGenerator cacheEntryGenerator, URIExtractor uriExtractor, HttpCache<CacheEntry> responseCache, CachedHttpResponseGenerator responseGenerator, CacheInvalidator cacheInvalidator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, ConditionalRequestBuilder conditionalRequestBuilder, CacheEntryUpdater entryUpdater, ResponseProtocolCompliance responseCompliance, RequestProtocolCompliance requestCompliance) {
        this.maxObjectSizeBytes = 8192;
        this.backend = backend;
        this.responseCachingPolicy = responseCachingPolicy;
        this.cacheEntryGenerator = cacheEntryGenerator;
        this.uriExtractor = uriExtractor;
        this.responseCache = responseCache;
        this.responseGenerator = responseGenerator;
        this.cacheInvalidator = cacheInvalidator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = suitabilityChecker;
        this.conditionalRequestBuilder = conditionalRequestBuilder;
        this.cacheEntryUpdater = entryUpdater;
        this.responseCompliance = responseCompliance;
        this.requestCompliance = requestCompliance;
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        HttpContext defaultContext = null;
        return this.execute(target, request, defaultContext);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request, responseHandler, null);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(target, request, context);
        return (T)responseHandler.handleResponse(resp);
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        HttpContext context = null;
        return this.execute(request, context);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        URI uri = request.getURI();
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        return this.execute(httpHost, (HttpRequest)request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request, responseHandler, null);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(request, context);
        return (T)responseHandler.handleResponse(resp);
    }

    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.backend.getParams();
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    protected CacheEntry getCacheEntry(HttpHost target, HttpRequest request) {
        String uri = this.uriExtractor.getURI(target, request);
        CacheEntry entry = null;
        try {
            entry = this.responseCache.getEntry(uri);
        }
        catch (HttpCacheOperationException ex) {
            this.log.debug((Object)"Was unable to get an entry from the cache based on the uri provided", (Throwable)ex);
        }
        if (entry == null || !entry.hasVariants()) {
            return entry;
        }
        String variantUri = this.uriExtractor.getVariantURI(target, request, entry);
        try {
            return this.responseCache.getEntry(variantUri);
        }
        catch (HttpCacheOperationException ex) {
            return null;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        if (this.clientRequestsOurOptions(request)) {
            return new OptionsHttp11Response();
        }
        List<RequestProtocolError> fatalError = this.requestCompliance.requestIsFatallyNonCompliant(request);
        Iterator<RequestProtocolError> i$ = fatalError.iterator();
        if (i$.hasNext()) {
            RequestProtocolError error = i$.next();
            return this.requestCompliance.getErrorForRequest(error);
        }
        try {
            request = this.requestCompliance.makeRequestCompliant(request);
        }
        catch (ProtocolException e) {
            throw new ClientProtocolException((Throwable)e);
        }
        this.cacheInvalidator.flushInvalidatedCacheEntries(target, request);
        if (!this.cacheableRequestPolicy.isServableFromCache(request)) {
            return this.callBackend(target, request, context);
        }
        CacheEntry entry = this.getCacheEntry(target, request);
        if (entry == null) {
            this.cacheMisses.getAndIncrement();
            if (this.log.isDebugEnabled()) {
                RequestLine rl = request.getRequestLine();
                this.log.debug((Object)("Cache miss [host: " + target + "; uri: " + rl.getUri() + "]"));
            }
            return this.callBackend(target, request, context);
        }
        if (this.log.isDebugEnabled()) {
            RequestLine rl = request.getRequestLine();
            this.log.debug((Object)("Cache hit [host: " + target + "; uri: " + rl.getUri() + "]"));
        }
        this.cacheHits.getAndIncrement();
        if (this.suitabilityChecker.canCachedResponseBeUsed(target, request, entry)) {
            return this.responseGenerator.generateResponse(entry);
        }
        if (entry.isRevalidatable()) {
            this.log.debug((Object)"Revalidating the cache entry");
            try {
                return this.revalidateCacheEntry(target, request, context, entry);
            }
            catch (IOException ioex) {
                HttpResponse response = this.responseGenerator.generateResponse(entry);
                response.addHeader("Warning", "111 Revalidation Failed - " + ioex.getMessage());
                this.log.debug((Object)("111 revalidation failed due to exception: " + ioex));
                return response;
            }
            catch (ProtocolException e) {
                throw new ClientProtocolException((Throwable)e);
            }
        }
        return this.callBackend(target, request, context);
    }

    private boolean clientRequestsOurOptions(HttpRequest request) {
        RequestLine line = request.getRequestLine();
        if (!"OPTIONS".equals(line.getMethod())) {
            return false;
        }
        if (!"*".equals(line.getUri())) {
            return false;
        }
        return "0".equals(request.getFirstHeader("Max-Forwards").getValue());
    }

    protected HttpResponse callBackend(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        Date requestDate = this.getCurrentDate();
        try {
            this.log.debug((Object)"Calling the backend");
            HttpResponse backendResponse = this.backend.execute(target, request, context);
            return this.handleBackendResponse(target, request, requestDate, this.getCurrentDate(), backendResponse);
        }
        catch (ClientProtocolException cpex) {
            throw cpex;
        }
        catch (IOException ex) {
            BasicStatusLine status = new BasicStatusLine(HTTP_1_1, 503, ex.getMessage());
            return new BasicHttpResponse((StatusLine)status);
        }
    }

    protected HttpResponse revalidateCacheEntry(HttpHost target, HttpRequest request, HttpContext context, CacheEntry cacheEntry) throws IOException, ProtocolException {
        HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(request, cacheEntry);
        Date requestDate = this.getCurrentDate();
        HttpResponse backendResponse = this.backend.execute(target, conditionalRequest, context);
        Date responseDate = this.getCurrentDate();
        int statusCode = backendResponse.getStatusLine().getStatusCode();
        if (statusCode == 304 || statusCode == 200) {
            this.cacheUpdates.getAndIncrement();
            CacheEntry updatedEntry = this.cacheEntryUpdater.updateCacheEntry(cacheEntry, requestDate, responseDate, backendResponse);
            this.storeInCache(target, request, updatedEntry);
            return this.responseGenerator.generateResponse(updatedEntry);
        }
        return this.handleBackendResponse(target, conditionalRequest, requestDate, responseDate, backendResponse);
    }

    protected void storeInCache(HttpHost target, HttpRequest request, CacheEntry entry) {
        if (entry.hasVariants()) {
            try {
                String uri = this.uriExtractor.getURI(target, request);
                HttpCacheUpdateCallback<CacheEntry> callback = this.storeVariantEntry(target, request, entry);
                this.responseCache.updateCacheEntry(uri, callback);
            }
            catch (HttpCacheOperationException ex) {
                this.log.debug((Object)"Was unable to PUT/UPDATE an entry into the cache based on the uri provided", (Throwable)ex);
            }
        } else {
            this.storeNonVariantEntry(target, request, entry);
        }
    }

    private void storeNonVariantEntry(HttpHost target, HttpRequest req, CacheEntry entry) {
        String uri = this.uriExtractor.getURI(target, req);
        try {
            this.responseCache.putEntry(uri, entry);
        }
        catch (HttpCacheOperationException ex) {
            this.log.debug((Object)"Was unable to PUT an entry into the cache based on the uri provided", (Throwable)ex);
        }
    }

    protected HttpCacheUpdateCallback<CacheEntry> storeVariantEntry(final HttpHost target, final HttpRequest req, final CacheEntry entry) {
        return new HttpCacheUpdateCallback<CacheEntry>(){

            @Override
            public CacheEntry getUpdatedEntry(CacheEntry existing) throws HttpCacheOperationException {
                return CachingHttpClient.this.doGetUpdatedParentEntry(existing, target, req, entry);
            }
        };
    }

    protected CacheEntry doGetUpdatedParentEntry(CacheEntry existing, HttpHost target, HttpRequest req, CacheEntry entry) throws HttpCacheOperationException {
        String variantURI = this.uriExtractor.getVariantURI(target, req, entry);
        this.responseCache.putEntry(variantURI, entry);
        if (existing != null) {
            return existing.addVariantURI(variantURI);
        }
        return entry.addVariantURI(variantURI);
    }

    protected HttpResponse handleBackendResponse(HttpHost target, HttpRequest request, Date requestDate, Date responseDate, HttpResponse backendResponse) throws IOException {
        this.log.debug((Object)"Handling Backend response");
        this.responseCompliance.ensureProtocolCompliance(request, backendResponse);
        boolean cacheable = this.responseCachingPolicy.isResponseCacheable(request, backendResponse);
        if (cacheable) {
            SizeLimitedResponseReader responseReader = this.getResponseReader(backendResponse);
            if (responseReader.isResponseTooLarge()) {
                return responseReader.getReconstructedResponse();
            }
            CacheEntry entry = this.cacheEntryGenerator.generateEntry(requestDate, responseDate, backendResponse, responseReader.getResponseBytes());
            this.storeInCache(target, request, entry);
            return this.responseGenerator.generateResponse(entry);
        }
        String uri = this.uriExtractor.getURI(target, request);
        try {
            this.responseCache.removeEntry(uri);
        }
        catch (HttpCacheOperationException ex) {
            this.log.debug((Object)"Was unable to remove an entry from the cache based on the uri provided", (Throwable)ex);
        }
        return backendResponse;
    }

    protected SizeLimitedResponseReader getResponseReader(HttpResponse backEndResponse) {
        return new SizeLimitedResponseReader(this.maxObjectSizeBytes, backEndResponse);
    }

    public boolean supportsRangeAndContentRangeHeaders() {
        return false;
    }
}

