/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolException;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.cache.CacheEntry;

@Immutable
public class ConditionalRequestBuilder {
    public HttpRequest buildConditionalRequest(HttpRequest request, CacheEntry cacheEntry) throws ProtocolException {
        RequestWrapper wrapperRequest = new RequestWrapper(request);
        wrapperRequest.resetHeaders();
        Header eTag = cacheEntry.getFirstHeader("ETag");
        if (eTag != null) {
            wrapperRequest.setHeader("If-None-Match", eTag.getValue());
        } else {
            Header lastModified = cacheEntry.getFirstHeader("Last-Modified");
            wrapperRequest.setHeader("If-Modified-Since", lastModified.getValue());
        }
        return wrapperRequest;
    }
}

