/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RequestProtocolCompliance {
    public List<RequestProtocolError> requestIsFatallyNonCompliant(HttpRequest request) {
        ArrayList<RequestProtocolError> theErrors = new ArrayList<RequestProtocolError>();
        RequestProtocolError anError = this.requestContainsBodyButNoLength(request);
        if (anError != null) {
            theErrors.add(anError);
        }
        if ((anError = this.requestHasWeakETagAndRange(request)) != null) {
            theErrors.add(anError);
        }
        if ((anError = this.requestHasWeekETagForPUTOrDELETEIfMatch(request)) != null) {
            theErrors.add(anError);
        }
        return theErrors;
    }

    public HttpRequest makeRequestCompliant(HttpRequest request) throws ProtocolException {
        if (this.requestMustNotHaveEntity(request)) {
            ((HttpEntityEnclosingRequest)request).setEntity(null);
        }
        this.verifyRequestWithExpectContinueFlagHas100continueHeader(request);
        this.verifyOPTIONSRequestWithBodyHasContentType(request);
        this.decrementOPTIONSMaxForwardsIfGreaterThen0(request);
        if (this.requestVersionIsTooLow(request)) {
            return this.upgradeRequestTo(request, CachingHttpClient.HTTP_1_1);
        }
        if (this.requestMinorVersionIsTooHighMajorVersionsMatch(request)) {
            return this.downgradeRequestTo(request, CachingHttpClient.HTTP_1_1);
        }
        return request;
    }

    private boolean requestMustNotHaveEntity(HttpRequest request) {
        return "TRACE".equals(request.getRequestLine().getMethod()) && request instanceof HttpEntityEnclosingRequest;
    }

    private void decrementOPTIONSMaxForwardsIfGreaterThen0(HttpRequest request) {
        if (!"OPTIONS".equals(request.getRequestLine().getMethod())) {
            return;
        }
        Header maxForwards = request.getFirstHeader("Max-Forwards");
        if (maxForwards == null) {
            return;
        }
        request.removeHeaders("Max-Forwards");
        int currentMaxForwards = Integer.parseInt(maxForwards.getValue());
        request.setHeader("Max-Forwards", Integer.toString(currentMaxForwards - 1));
    }

    private void verifyOPTIONSRequestWithBodyHasContentType(HttpRequest request) {
        if (!"OPTIONS".equals(request.getRequestLine().getMethod())) {
            return;
        }
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        this.addContentTypeHeaderIfMissing((HttpEntityEnclosingRequest)request);
    }

    private void addContentTypeHeaderIfMissing(HttpEntityEnclosingRequest request) {
        if (request.getEntity().getContentType() == null) {
            ((AbstractHttpEntity)request.getEntity()).setContentType("application/octet-stream");
        }
    }

    private void verifyRequestWithExpectContinueFlagHas100continueHeader(HttpRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            if (((HttpEntityEnclosingRequest)request).expectContinue() && ((HttpEntityEnclosingRequest)request).getEntity() != null) {
                this.add100ContinueHeaderIfMissing(request);
            } else {
                this.remove100ContinueHeaderIfExists(request);
            }
        } else {
            this.remove100ContinueHeaderIfExists(request);
        }
    }

    private void remove100ContinueHeaderIfExists(HttpRequest request) {
        boolean hasHeader = false;
        Header[] expectHeaders = request.getHeaders("Expect");
        ArrayList<HeaderElement> expectElementsThatAreNot100Continue = new ArrayList<HeaderElement>();
        for (Header h : expectHeaders) {
            for (HeaderElement elt : h.getElements()) {
                if (!"100-continue".equalsIgnoreCase(elt.getName())) {
                    expectElementsThatAreNot100Continue.add(elt);
                    continue;
                }
                hasHeader = true;
            }
            if (hasHeader) {
                request.removeHeader(h);
                for (HeaderElement elt : expectElementsThatAreNot100Continue) {
                    BasicHeader newHeader = new BasicHeader("Expect", elt.getName());
                    request.addHeader((Header)newHeader);
                }
                return;
            }
            expectElementsThatAreNot100Continue = new ArrayList();
        }
    }

    private void add100ContinueHeaderIfMissing(HttpRequest request) {
        boolean hasHeader = false;
        for (Header h : request.getHeaders("Expect")) {
            for (HeaderElement elt : h.getElements()) {
                if (!"100-continue".equalsIgnoreCase(elt.getName())) continue;
                hasHeader = true;
            }
        }
        if (!hasHeader) {
            request.addHeader("Expect", "100-continue");
        }
    }

    private HttpRequest upgradeRequestTo(HttpRequest request, ProtocolVersion version) throws ProtocolException {
        RequestWrapper newRequest = new RequestWrapper(request);
        newRequest.setProtocolVersion(version);
        return newRequest;
    }

    private HttpRequest downgradeRequestTo(HttpRequest request, ProtocolVersion version) throws ProtocolException {
        RequestWrapper newRequest = new RequestWrapper(request);
        newRequest.setProtocolVersion(version);
        return newRequest;
    }

    protected boolean requestMinorVersionIsTooHighMajorVersionsMatch(HttpRequest request) {
        ProtocolVersion requestProtocol = request.getProtocolVersion();
        if (requestProtocol.getMajor() != CachingHttpClient.HTTP_1_1.getMajor()) {
            return false;
        }
        return requestProtocol.getMinor() > CachingHttpClient.HTTP_1_1.getMinor();
    }

    protected boolean requestVersionIsTooLow(HttpRequest request) {
        return request.getProtocolVersion().compareToVersion(CachingHttpClient.HTTP_1_1) < 0;
    }

    public HttpResponse getErrorForRequest(RequestProtocolError errorCheck) {
        switch (errorCheck) {
            case BODY_BUT_NO_LENGTH_ERROR: {
                return new BasicHttpResponse((StatusLine)new BasicStatusLine(CachingHttpClient.HTTP_1_1, 411, ""));
            }
            case WEAK_ETAG_AND_RANGE_ERROR: {
                return new BasicHttpResponse((StatusLine)new BasicStatusLine(CachingHttpClient.HTTP_1_1, 400, "Weak eTag not compatible with byte range"));
            }
            case WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR: {
                return new BasicHttpResponse((StatusLine)new BasicStatusLine(CachingHttpClient.HTTP_1_1, 400, "Weak eTag not compatible with PUT or DELETE requests"));
            }
        }
        throw new IllegalStateException("The request was compliant, therefore no error can be generated for it.");
    }

    private RequestProtocolError requestHasWeakETagAndRange(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        if (!"GET".equals(method)) {
            return null;
        }
        Header range = request.getFirstHeader("Range");
        if (range == null) {
            return null;
        }
        Header ifRange = request.getFirstHeader("If-Range");
        if (ifRange == null) {
            return null;
        }
        String val = ifRange.getValue();
        if (val.startsWith("W/")) {
            return RequestProtocolError.WEAK_ETAG_AND_RANGE_ERROR;
        }
        return null;
    }

    private RequestProtocolError requestHasWeekETagForPUTOrDELETEIfMatch(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        if (!"PUT".equals(method) && !"DELETE".equals(method)) {
            return null;
        }
        Header ifMatch = request.getFirstHeader("If-Match");
        if (ifMatch != null) {
            String val = ifMatch.getValue();
            if (val.startsWith("W/")) {
                return RequestProtocolError.WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR;
            }
        } else {
            Header ifNoneMatch = request.getFirstHeader("If-None-Match");
            if (ifNoneMatch == null) {
                return null;
            }
            String val2 = ifNoneMatch.getValue();
            if (val2.startsWith("W/")) {
                return RequestProtocolError.WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR;
            }
        }
        return null;
    }

    private RequestProtocolError requestContainsBodyButNoLength(HttpRequest request) {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return null;
        }
        if (request.getFirstHeader("Content-Length") != null && ((HttpEntityEnclosingRequest)request).getEntity() != null) {
            return null;
        }
        return RequestProtocolError.BODY_BUT_NO_LENGTH_ERROR;
    }
}

