/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.cache.CombinedInputStream;
import org.apache.http.message.BasicHttpResponse;

public class SizeLimitedResponseReader {
    private final int maxResponseSizeBytes;
    private final HttpResponse response;
    ByteArrayOutputStream outputStream;
    InputStream contentInputStream;
    private boolean isTooLarge;
    private boolean responseIsConsumed;
    private byte[] sizeLimitedContent;
    private boolean outputStreamConsumed;

    public SizeLimitedResponseReader(int maxResponseSizeBytes, HttpResponse response) {
        this.maxResponseSizeBytes = maxResponseSizeBytes;
        this.response = response;
    }

    protected boolean isResponseTooLarge() throws IOException {
        if (!this.responseIsConsumed) {
            this.isTooLarge = this.consumeResponse();
        }
        return this.isTooLarge;
    }

    private synchronized boolean consumeResponse() throws IOException {
        int current;
        if (this.responseIsConsumed) {
            throw new IllegalStateException("You cannot call this method more than once, because it consumes an underlying stream");
        }
        this.responseIsConsumed = true;
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            return false;
        }
        this.contentInputStream = entity.getContent();
        this.outputStream = new ByteArrayOutputStream();
        for (int bytes = 0; bytes < this.maxResponseSizeBytes && (current = this.contentInputStream.read()) != -1; ++bytes) {
            this.outputStream.write(current);
        }
        current = this.contentInputStream.read();
        if (current != -1) {
            this.outputStream.write(current);
            return true;
        }
        return false;
    }

    private synchronized void consumeOutputStream() {
        if (this.outputStreamConsumed) {
            throw new IllegalStateException("underlying output stream has already been written to byte[]");
        }
        if (!this.responseIsConsumed) {
            throw new IllegalStateException("Must call consumeResponse first.");
        }
        this.sizeLimitedContent = this.outputStream.toByteArray();
        this.outputStreamConsumed = true;
    }

    protected byte[] getResponseBytes() {
        if (!this.outputStreamConsumed) {
            this.consumeOutputStream();
        }
        return this.sizeLimitedContent;
    }

    protected HttpResponse getReconstructedResponse() {
        InputStream combinedStream = this.getCombinedInputStream();
        return this.constructResponse(this.response, combinedStream);
    }

    protected InputStream getCombinedInputStream() {
        ByteArrayInputStream input1 = new ByteArrayInputStream(this.getResponseBytes());
        InputStream input2 = this.getContentInputStream();
        return new CombinedInputStream(input1, input2);
    }

    protected InputStream getContentInputStream() {
        return this.contentInputStream;
    }

    protected HttpResponse constructResponse(HttpResponse originalResponse, InputStream combinedStream) {
        BasicHttpResponse response = new BasicHttpResponse(originalResponse.getProtocolVersion(), 200, "Success");
        InputStreamEntity entity = new InputStreamEntity(combinedStream, -1L);
        response.setEntity((HttpEntity)entity);
        response.setHeaders(originalResponse.getAllHeaders());
        return response;
    }
}

