/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.impl.client.cache.CacheEntry;

@Immutable
public class URIExtractor {
    public String getURI(HttpHost host, HttpRequest req) {
        return String.format("%s%s", host.toString(), req.getRequestLine().getUri());
    }

    protected String getFullHeaderValue(Header[] headers) {
        if (headers == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("");
        boolean first = true;
        for (Header hdr : headers) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(hdr.getValue().trim());
            first = false;
        }
        return buf.toString();
    }

    public String getVariantURI(HttpHost host, HttpRequest req, CacheEntry entry) {
        Header[] varyHdrs = entry.getHeaders("Vary");
        if (varyHdrs == null || varyHdrs.length == 0) {
            return this.getURI(host, req);
        }
        ArrayList<String> variantHeaderNames = new ArrayList<String>();
        for (Header varyHdr : varyHdrs) {
            for (HeaderElement elt : varyHdr.getElements()) {
                variantHeaderNames.add(elt.getName());
            }
        }
        Collections.sort(variantHeaderNames);
        try {
            StringBuilder buf = new StringBuilder("{");
            boolean first = true;
            for (String headerName : variantHeaderNames) {
                if (!first) {
                    buf.append("&");
                }
                buf.append(URLEncoder.encode(headerName, "UTF-8"));
                buf.append("=");
                buf.append(URLEncoder.encode(this.getFullHeaderValue(req.getHeaders(headerName)), "UTF-8"));
                first = false;
            }
            buf.append("}");
            buf.append(this.getURI(host, req));
            return buf.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("couldn't encode to UTF-8", uee);
        }
    }
}

