/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.sql.cache;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.extension.sql.Node;
import org.seasar.extension.sql.parser.SqlParserImpl;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class NodeCache {
    private static volatile boolean initialized;
    private static ConcurrentHashMap<String, Node> nodeCache;

    public static Node getNode(String path, String dbmsName) {
        return NodeCache.getNode(path, dbmsName, true);
    }

    public static Node getNode(String path, String dbmsName, boolean allowVariableSql) {
        if (!initialized) {
            NodeCache.initialize();
        }
        if (path.endsWith(".sql")) {
            path = path.substring(0, path.length() - 4);
        }
        String key = path;
        if (!allowVariableSql) {
            key = key + "_disallowVariableSql";
        }
        Node node = null;
        if (dbmsName != null) {
            String dbmsSpecificKey = key + "_" + dbmsName;
            node = nodeCache.get(dbmsSpecificKey);
            if (node != null) {
                return node;
            }
            String dbmsSpecificPath = path + "_" + dbmsName;
            node = NodeCache.createNode(dbmsSpecificPath, allowVariableSql);
            if (node != null) {
                return CollectionsUtil.putIfAbsent(nodeCache, dbmsSpecificKey, node);
            }
        }
        if ((node = nodeCache.get(key)) != null) {
            return node;
        }
        node = NodeCache.createNode(path, allowVariableSql);
        if (node != null) {
            return CollectionsUtil.putIfAbsent(nodeCache, key, node);
        }
        return null;
    }

    private static Node createNode(String path, boolean allowVariableSql) {
        InputStream is = ResourceUtil.getResourceAsStreamNoException((String)path, (String)"sql");
        if (is == null) {
            return null;
        }
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)"UTF-8");
        String sql = ReaderUtil.readText((Reader)reader);
        if (sql.length() > 0 && sql.charAt(0) == '\ufeff') {
            sql = sql.substring(1);
        }
        return new SqlParserImpl(sql, allowVariableSql).parse();
    }

    public static void initialize() {
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                NodeCache.clear();
            }
        });
        initialized = true;
    }

    public static void clear() {
        nodeCache.clear();
        initialized = false;
    }

    static {
        nodeCache = CollectionsUtil.newConcurrentHashMap(200);
        NodeCache.initialize();
    }
}

