/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.RTimer;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseBuilder {
    public SolrQueryRequest req;
    public SolrQueryResponse rsp;
    public boolean doHighlights;
    public boolean doFacets;
    public boolean doStats;
    private boolean needDocList = false;
    private boolean needDocSet = false;
    private int fieldFlags = 0;
    private boolean debug = false;
    private QParser qparser = null;
    private String queryString = null;
    private Query query = null;
    private List<Query> filters = null;
    private SortSpec sortSpec = null;
    private DocListAndSet results = null;
    private NamedList<Object> debugInfo = null;
    private RTimer timer = null;
    private Query highlightQuery = null;
    public List<SearchComponent> components;
    public static final String FIELD_SORT_VALUES = "fsv";
    public static final String SHARDS = "shards";
    public static final String IDS = "ids";
    public static int STAGE_START = 0;
    public static int STAGE_PARSE_QUERY = 1000;
    public static int STAGE_EXECUTE_QUERY = 2000;
    public static int STAGE_GET_FIELDS = 3000;
    public static int STAGE_DONE = Integer.MAX_VALUE;
    public int stage;
    public String[] shards;
    public int shards_rows = -1;
    public int shards_start = -1;
    public List<ShardRequest> outgoing;
    public List<ShardRequest> finished;
    public GlobalCollectionStat globalCollectionStat;
    Map<Object, ShardDoc> resultIds;
    public FacetComponent.FacetInfo _facetInfo;
    SolrDocumentList _responseDocs;
    StatsInfo _statsInfo;

    public int getShardNum(String shard) {
        for (int i = 0; i < this.shards.length; ++i) {
            if (this.shards[i] != shard && !this.shards[i].equals(shard)) continue;
            return i;
        }
        return -1;
    }

    public void addRequest(SearchComponent me, ShardRequest sreq) {
        this.outgoing.add(sreq);
        if ((sreq.purpose & 1) == 0) {
            for (SearchComponent component : this.components) {
                if (component == me) continue;
                component.modifyRequest(this, me, sreq);
            }
        }
    }

    public void addDebugInfo(String name, Object val) {
        if (this.debugInfo == null) {
            this.debugInfo = new SimpleOrderedMap();
        }
        this.debugInfo.add(name, val);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public NamedList<Object> getDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(NamedList<Object> debugInfo) {
        this.debugInfo = debugInfo;
    }

    public int getFieldFlags() {
        return this.fieldFlags;
    }

    public void setFieldFlags(int fieldFlags) {
        this.fieldFlags = fieldFlags;
    }

    public List<Query> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Query> filters) {
        this.filters = filters;
    }

    public Query getHighlightQuery() {
        return this.highlightQuery;
    }

    public void setHighlightQuery(Query highlightQuery) {
        this.highlightQuery = highlightQuery;
    }

    public boolean isNeedDocList() {
        return this.needDocList;
    }

    public void setNeedDocList(boolean needDocList) {
        this.needDocList = needDocList;
    }

    public boolean isNeedDocSet() {
        return this.needDocSet;
    }

    public void setNeedDocSet(boolean needDocSet) {
        this.needDocSet = needDocSet;
    }

    public QParser getQparser() {
        return this.qparser;
    }

    public void setQparser(QParser qparser) {
        this.qparser = qparser;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String qstr) {
        this.queryString = qstr;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public DocListAndSet getResults() {
        return this.results;
    }

    public void setResults(DocListAndSet results) {
        this.results = results;
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    public void setSortSpec(SortSpec sort) {
        this.sortSpec = sort;
    }

    public RTimer getTimer() {
        return this.timer;
    }

    public void setTimer(RTimer timer) {
        this.timer = timer;
    }

    public SolrIndexSearcher.QueryCommand getQueryCommand() {
        SolrIndexSearcher.QueryCommand cmd = new SolrIndexSearcher.QueryCommand();
        cmd.setQuery(this.getQuery()).setFilterList(this.getFilters()).setSort(this.getSortSpec().getSort()).setOffset(this.getSortSpec().getOffset()).setLen(this.getSortSpec().getCount()).setFlags(this.getFieldFlags()).setNeedDocSet(this.isNeedDocSet());
        return cmd;
    }

    public void setResult(SolrIndexSearcher.QueryResult result) {
        this.setResults(result.getDocListAndSet());
        if (result.isPartialResults()) {
            this.rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalCollectionStat {
        public final long numDocs;
        public final Map<String, Long> dfMap;

        public GlobalCollectionStat(int numDocs, Map<String, Long> dfMap) {
            this.numDocs = numDocs;
            this.dfMap = dfMap;
        }
    }
}

