/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public abstract class Expression {
    private boolean addedToFilter;

    public abstract Value getValue(Session var1);

    public abstract int getType();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract Expression optimize(Session var1);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract int getScale();

    public abstract long getPrecision();

    public abstract int getDisplaySize();

    public abstract String getSQL();

    public abstract void updateAggregate(Session var1);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract int getCost();

    public final boolean isEverything(int n) {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(n);
        return this.isEverything(expressionVisitor);
    }

    public Expression getNotIfPossible(Session session) {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public Boolean getBooleanValue(Session session) {
        return this.getValue(session).getBoolean();
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
    }

    public String getColumnName() {
        return this.getAlias();
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public int getNullable() {
        return 2;
    }

    public String getTableAlias() {
        return null;
    }

    public String getAlias() {
        return StringUtils.unEnclose(this.getSQL());
    }

    public boolean isWildcard() {
        return false;
    }

    public Expression getNonAliasExpression() {
        return this;
    }

    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (!this.addedToFilter && !bl && this.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
            tableFilter.addFilterCondition(this, false);
            this.addedToFilter = true;
        }
    }

    public String toString() {
        return this.getSQL();
    }

    public Expression[] getExpressionColumns(Session session) {
        return null;
    }

    public static Expression[] getExpressionColumns(Session session, ValueArray valueArray) {
        Value[] valueArray2 = valueArray.getList();
        Expression[] expressionArray = new ExpressionColumn[valueArray2.length];
        int n = valueArray2.length;
        for (int i = 0; i < n; ++i) {
            Value value = valueArray2[i];
            Column column = new Column("C" + (i + 1), value.getType(), value.getPrecision(), value.getScale(), value.getDisplaySize());
            expressionArray[i] = new ExpressionColumn(session.getDatabase(), column);
        }
        return expressionArray;
    }

    public static Expression[] getExpressionColumns(Session session, ResultSet resultSet) {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            Expression[] expressionArray = new Expression[n];
            Database database = session == null ? null : session.getDatabase();
            for (int i = 0; i < n; ++i) {
                String string = resultSetMetaData.getColumnLabel(i + 1);
                int n2 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(i + 1));
                int n3 = resultSetMetaData.getPrecision(i + 1);
                int n4 = resultSetMetaData.getScale(i + 1);
                int n5 = resultSetMetaData.getColumnDisplaySize(i + 1);
                Column column = new Column(string, n2, n3, n4, n5);
                ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
                expressionArray[i] = expressionColumn;
            }
            return expressionArray;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }
}

