/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlBasicExecutor;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlEntityExecutor;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.PagingOverSafetySizeException;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlPagingExecutor {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final String _tableDbName;
    protected final DBDef _currentDBDef;
    protected final StatementConfig _defaultStatementConfig;
    protected final OutsideSqlOption _outsideSqlOption;

    public OutsideSqlPagingExecutor(BehaviorCommandInvoker behaviorCommandInvoker, String tableDbName, DBDef currentDBDef, StatementConfig defaultStatementConfig, OutsideSqlOption outsideSqlOption) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
        this._defaultStatementConfig = defaultStatementConfig;
        this._outsideSqlOption = outsideSqlOption;
    }

    public <ENTITY> PagingResultBean<ENTITY> selectPage(String path, PagingBean pmb, Class<ENTITY> entityType) {
        try {
            PagingHandler<ENTITY> handler = this.createPagingHandler(path, pmb, entityType);
            PagingInvoker<ENTITY> invoker = this.createPagingInvoker();
            return invoker.invokePaging(handler);
        }
        catch (PagingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(pmb, e);
            return null;
        }
    }

    protected <ENTITY> PagingHandler<ENTITY> createPagingHandler(final String path, final PagingBean pmb, final Class<ENTITY> entityType) {
        final OutsideSqlEntityExecutor<PagingBean> countExecutor = this.createCountExecutor();
        return new PagingHandler<ENTITY>(){

            @Override
            public PagingBean getPagingBean() {
                return pmb;
            }

            @Override
            public int count() {
                pmb.xsetPaging(false);
                return countExecutor.selectEntityWithDeletedCheck(path, pmb, Integer.class);
            }

            @Override
            public List<ENTITY> paging() {
                pmb.xsetPaging(true);
                return OutsideSqlPagingExecutor.this.doSelectList(path, pmb, entityType);
            }
        };
    }

    protected OutsideSqlEntityExecutor<PagingBean> createCountExecutor() {
        OutsideSqlOption countOption = this._outsideSqlOption.copyOptionWithoutPaging();
        return new OutsideSqlEntityExecutor<PagingBean>(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, countOption);
    }

    protected <ENTITY> PagingInvoker<ENTITY> createPagingInvoker() {
        return new PagingInvoker(this._tableDbName);
    }

    protected void setupScrollableCursorIfNeeds() {
        if (!this._outsideSqlOption.isAutoPaging()) {
            return;
        }
        StatementConfig statementConfig = this._outsideSqlOption.getStatementConfig();
        if (statementConfig != null && statementConfig.hasResultSetType()) {
            return;
        }
        if (this._defaultStatementConfig != null && this._defaultStatementConfig.hasResultSetType()) {
            return;
        }
        if (statementConfig == null) {
            statementConfig = new StatementConfig();
            this.configure(statementConfig);
        }
        if (this._currentDBDef.dbway().isScrollableCursorSupported()) {
            statementConfig.typeScrollInsensitive();
        } else {
            statementConfig.typeForwardOnly();
        }
    }

    public <ENTITY> ListResultBean<ENTITY> selectList(String path, PagingBean pmb, Class<ENTITY> entityType) {
        return this.doSelectList(path, pmb, entityType);
    }

    protected <ENTITY> ListResultBean<ENTITY> doSelectList(String path, PagingBean pmb, Class<ENTITY> entityType) {
        this.setupScrollableCursorIfNeeds();
        try {
            return this.createBasicExecutor().selectList(path, pmb, entityType);
        }
        catch (FetchingOverSafetySizeException e) {
            this.createBhvExThrower().throwDangerousResultSizeException(pmb, e);
            return null;
        }
    }

    protected OutsideSqlBasicExecutor createBasicExecutor() {
        return new OutsideSqlBasicExecutor(this._behaviorCommandInvoker, this._tableDbName, this._currentDBDef, this._defaultStatementConfig, this._outsideSqlOption);
    }

    public OutsideSqlPagingExecutor dynamicBinding() {
        this._outsideSqlOption.dynamicBinding();
        return this;
    }

    public OutsideSqlPagingExecutor removeBlockComment() {
        this._outsideSqlOption.removeBlockComment();
        return this;
    }

    public OutsideSqlPagingExecutor removeLineComment() {
        this._outsideSqlOption.removeLineComment();
        return this;
    }

    public OutsideSqlPagingExecutor formatSql() {
        this._outsideSqlOption.formatSql();
        return this;
    }

    public OutsideSqlPagingExecutor configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return this._behaviorCommandInvoker.createBehaviorExceptionThrower();
    }
}

