/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.seasar.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.dbflute.twowaysql.node.Node;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnUpdateQueryAutoDynamicCommand
implements TnSqlCommand,
SqlExecution {
    protected final DataSource _dataSource;
    protected final StatementFactory _statementFactory;
    protected TnBeanMetaData _beanMetaData;

    public TnUpdateQueryAutoDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        this._dataSource = dataSource;
        this._statementFactory = statementFactory;
    }

    @Override
    public Object execute(Object[] args) {
        ConditionBean cb = this.extractConditionBeanWithCheck(args);
        Entity entity = this.extractEntityWithCheck(args);
        UpdateOption<ConditionBean> option = this.extractUpdateOptionWithCheck(args);
        String[] argNames = new String[]{"pmb", "entity"};
        Class[] argTypes = new Class[]{cb.getClass(), entity.getClass()};
        ArrayList<TnPropertyType> boundPropTypeList = new ArrayList<TnPropertyType>();
        String twoWaySql = this.buildQueryUpdateTwoWaySql(entity, cb, option, boundPropTypeList);
        if (twoWaySql == null) {
            return 0;
        }
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, args);
        TnCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setExceptionMessageSqlArgs(context.getBindVariables());
        handler.setBoundPropTypeList(boundPropTypeList);
        int rows = handler.execute(args);
        return rows;
    }

    protected ConditionBean extractConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object fisrtArg = args[0];
        if (!(fisrtArg instanceof ConditionBean)) {
            String msg = "The type of first argument should be " + ConditionBean.class + ":";
            msg = msg + " type=" + fisrtArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)fisrtArg;
    }

    protected Entity extractEntityWithCheck(Object[] args) {
        this.assertArgument(args);
        Object secondArg = args[1];
        if (!(secondArg instanceof Entity)) {
            String msg = "The type of second argument should be " + Entity.class + ":";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (Entity)secondArg;
    }

    protected UpdateOption<ConditionBean> extractUpdateOptionWithCheck(Object[] args) {
        this.assertArgument(args);
        if (args.length < 3) {
            return null;
        }
        Object secondArg = args[2];
        if (secondArg == null) {
            return null;
        }
        if (!(secondArg instanceof UpdateOption)) {
            String msg = "The type of third argument should be " + UpdateOption.class + ":";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        UpdateOption option = (UpdateOption)secondArg;
        return option;
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument at least! But:";
            msg = msg + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected String buildQueryUpdateTwoWaySql(Entity entity, ConditionBean cb, UpdateOption<ConditionBean> option, List<TnPropertyType> boundPropTypeList) {
        String columnName;
        ColumnInfo columnInfo;
        LinkedHashMap<String, String> columnParameterMap = new LinkedHashMap<String, String>();
        DBMeta dbmeta = entity.getDBMeta();
        Set<String> modifiedPropertyNames = entity.getModifiedPropertyNames();
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        for (ColumnInfo columnInfo2 : columnInfoList) {
            String columnDbName = columnInfo2.getColumnDbName();
            if (option != null && option.hasStatement(columnDbName)) {
                String statement = option.buildStatement(columnDbName);
                columnParameterMap.put(columnDbName, statement);
                continue;
            }
            String propertyName = columnInfo2.getPropertyName();
            if (!modifiedPropertyNames.contains(propertyName)) continue;
            Object value = columnInfo2.read(entity);
            if (value != null) {
                columnParameterMap.put(columnDbName, "/*entity." + propertyName + "*/null");
                TnPropertyType propertyType = this._beanMetaData.getPropertyType(propertyName);
                boundPropTypeList.add(propertyType);
                continue;
            }
            columnParameterMap.put(columnDbName, "null");
        }
        if (columnParameterMap.isEmpty()) {
            return null;
        }
        if (dbmeta.hasVersionNo()) {
            columnInfo = dbmeta.getVersionNoColumnInfo();
            columnName = columnInfo.getColumnDbName();
            columnParameterMap.put(columnName, columnName + " + 1");
        }
        if (dbmeta.hasUpdateDate()) {
            columnInfo = dbmeta.getUpdateDateColumnInfo();
            columnInfo.write(entity, ResourceContext.getAccessTimestamp());
            columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            columnParameterMap.put(columnName, "/*entity." + propertyName + "*/null");
            boundPropTypeList.add(this._beanMetaData.getPropertyType(propertyName));
        }
        return cb.getSqlClause().getClauseQueryUpdate(columnParameterMap);
    }

    protected CommandContext createCommandContext(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        SqlAnalyzer analyzer = this.createSqlAnalyzer(twoWaySql);
        Node node = analyzer.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        return context;
    }

    protected SqlAnalyzer createSqlAnalyzer(String sql) {
        return ResourceContext.createSqlAnalyzer(sql, true);
    }

    protected TnCommandContextHandler createCommandContextHandler(CommandContext context) {
        return new TnCommandContextHandler(this._dataSource, this._statementFactory, context);
    }

    protected String replace(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public TnBeanMetaData getBeanMetaData() {
        return this._beanMetaData;
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this._beanMetaData = beanMetaData;
    }
}

