/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.jdbc.Classification;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.valuetype.basic.BigDecimalType;
import org.seasar.dbflute.s2dao.valuetype.basic.BigIntegerType;
import org.seasar.dbflute.s2dao.valuetype.basic.BinaryStreamType;
import org.seasar.dbflute.s2dao.valuetype.basic.BinaryType;
import org.seasar.dbflute.s2dao.valuetype.basic.BooleanType;
import org.seasar.dbflute.s2dao.valuetype.basic.ByteType;
import org.seasar.dbflute.s2dao.valuetype.basic.CharacterType;
import org.seasar.dbflute.s2dao.valuetype.basic.ClassificationType;
import org.seasar.dbflute.s2dao.valuetype.basic.DoubleType;
import org.seasar.dbflute.s2dao.valuetype.basic.FloatType;
import org.seasar.dbflute.s2dao.valuetype.basic.IntegerType;
import org.seasar.dbflute.s2dao.valuetype.basic.LongType;
import org.seasar.dbflute.s2dao.valuetype.basic.ObjectType;
import org.seasar.dbflute.s2dao.valuetype.basic.ShortType;
import org.seasar.dbflute.s2dao.valuetype.basic.SqlDateType;
import org.seasar.dbflute.s2dao.valuetype.basic.StringType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimeType;
import org.seasar.dbflute.s2dao.valuetype.basic.TimestampType;
import org.seasar.dbflute.s2dao.valuetype.basic.UUIDAsDirectType;
import org.seasar.dbflute.s2dao.valuetype.basic.UUIDAsStringType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsSqlDateType;
import org.seasar.dbflute.s2dao.valuetype.basic.UtilDateAsTimestampType;
import org.seasar.dbflute.s2dao.valuetype.plugin.BytesOidType;
import org.seasar.dbflute.s2dao.valuetype.plugin.BytesType;
import org.seasar.dbflute.s2dao.valuetype.plugin.FixedLengthStringType;
import org.seasar.dbflute.s2dao.valuetype.plugin.ObjectBindingBigDecimalType;
import org.seasar.dbflute.s2dao.valuetype.plugin.OracleResultSetType;
import org.seasar.dbflute.s2dao.valuetype.plugin.PostgreSQLResultSetType;
import org.seasar.dbflute.s2dao.valuetype.plugin.SerializableType;
import org.seasar.dbflute.s2dao.valuetype.plugin.StringClobType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType BYTE = new ByteType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType BIGINTEGER = new BigIntegerType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType UTILDATE_AS_SQLDATE = new UtilDateAsSqlDateType();
    public static final ValueType UTILDATE_AS_TIMESTAMP = new UtilDateAsTimestampType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType UUID_AS_DIRECT = new UUIDAsDirectType();
    public static final ValueType UUID_AS_STRING = new UUIDAsStringType();
    public static final ValueType CLASSIFICATION = new ClassificationType();
    public static final ValueType DEFAULT_OBJECT = new ObjectType();
    public static final ValueType STRING_CLOB = new StringClobType();
    public static final ValueType BYTES_OID = new BytesOidType();
    public static final ValueType FIXED_LENGTH_STRING = new FixedLengthStringType();
    public static final ValueType OBJECT_BINDING_BIGDECIMAL = new ObjectBindingBigDecimalType();
    public static final ValueType POSTGRESQL_RESULT_SET = new PostgreSQLResultSetType();
    public static final ValueType ORACLE_RESULT_SET = new OracleResultSetType();
    public static final ValueType SERIALIZABLE_BYTE_ARRAY = new SerializableType(BytesType.BYTES_TRAIT);
    protected static final Class<?> BYTE_ARRAY_CLASS = new byte[0].getClass();
    protected static final Map<Class<?>, ValueType> _basicObjectValueTypeMap = new ConcurrentHashMap();
    protected static final Map<Class<?>, ValueType> _basicInterfaceValueTypeMap = new ConcurrentHashMap();
    protected static final Map<String, ValueType> _pluginValueTypeMap = new ConcurrentHashMap<String, ValueType>();
    protected static final Map<Integer, ValueType> _dynamicObjectValueTypeMap = new ConcurrentHashMap<Integer, ValueType>();

    protected static void initialize() {
        TnValueTypes.registerBasicValueType(String.class, STRING);
        TnValueTypes.registerBasicValueType(Character.TYPE, CHARACTER);
        TnValueTypes.registerBasicValueType(Character.class, CHARACTER);
        TnValueTypes.registerBasicValueType(Byte.TYPE, BYTE);
        TnValueTypes.registerBasicValueType(Byte.class, BYTE);
        TnValueTypes.registerBasicValueType(Short.TYPE, SHORT);
        TnValueTypes.registerBasicValueType(Short.class, SHORT);
        TnValueTypes.registerBasicValueType(Integer.TYPE, INTEGER);
        TnValueTypes.registerBasicValueType(Integer.class, INTEGER);
        TnValueTypes.registerBasicValueType(Long.TYPE, LONG);
        TnValueTypes.registerBasicValueType(Long.class, LONG);
        TnValueTypes.registerBasicValueType(Float.TYPE, FLOAT);
        TnValueTypes.registerBasicValueType(Float.class, FLOAT);
        TnValueTypes.registerBasicValueType(Double.TYPE, DOUBLE);
        TnValueTypes.registerBasicValueType(Double.class, DOUBLE);
        TnValueTypes.registerBasicValueType(BigInteger.class, BIGINTEGER);
        TnValueTypes.registerBasicValueType(BigDecimal.class, BIGDECIMAL);
        TnValueTypes.registerBasicValueType(Date.class, SQLDATE);
        TnValueTypes.registerBasicValueType(Time.class, TIME);
        TnValueTypes.registerBasicValueType(java.util.Date.class, UTILDATE_AS_SQLDATE);
        TnValueTypes.registerBasicValueType(Timestamp.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(Calendar.class, TIMESTAMP);
        TnValueTypes.registerBasicValueType(BYTE_ARRAY_CLASS, BINARY);
        TnValueTypes.registerBasicValueType(InputStream.class, BINARY_STREAM);
        TnValueTypes.registerBasicValueType(Boolean.TYPE, BOOLEAN);
        TnValueTypes.registerBasicValueType(Boolean.class, BOOLEAN);
        TnValueTypes.registerBasicValueType(UUID.class, UUID_AS_DIRECT);
        TnValueTypes.registerBasicValueType(Classification.class, CLASSIFICATION);
        TnValueTypes.registerPluginValueType("stringClobType", STRING_CLOB);
        TnValueTypes.registerPluginValueType("bytesOidType", BYTES_OID);
        TnValueTypes.registerPluginValueType("fixedLengthStringType", FIXED_LENGTH_STRING);
        TnValueTypes.registerPluginValueType("objectBindingBigDecimalType", OBJECT_BINDING_BIGDECIMAL);
    }

    protected TnValueTypes() {
    }

    public static ValueType findByTypeOrValue(Class<?> type, Object value) {
        ValueType byType = TnValueTypes.getValueType(type);
        if (!TnValueTypes.isDefaultObject(byType)) {
            return byType;
        }
        return TnValueTypes.getValueType(value);
    }

    public static ValueType findByValueOrJdbcDefType(Object value, int jdbcDefType) {
        ValueType byValue = TnValueTypes.getValueType(value);
        if (!TnValueTypes.isDefaultObject(byValue)) {
            return byValue;
        }
        return TnValueTypes.getValueType(jdbcDefType);
    }

    public static ValueType getValueType(Object value) {
        if (value == null) {
            return DEFAULT_OBJECT;
        }
        return TnValueTypes.getValueType(value.getClass());
    }

    public static ValueType getValueType(Class<?> type) {
        if (type == null) {
            return DEFAULT_OBJECT;
        }
        boolean interfaceFirst = Enum.class.isAssignableFrom(type);
        ValueType valueType = null;
        if (interfaceFirst) {
            valueType = TnValueTypes.getBasicInterfaceValueType(type);
            if (valueType == null) {
                valueType = TnValueTypes.getBasicObjectValueType(type);
            }
        } else {
            valueType = TnValueTypes.getBasicObjectValueType(type);
            if (valueType == null) {
                valueType = TnValueTypes.getBasicInterfaceValueType(type);
            }
        }
        return valueType != null ? valueType : DEFAULT_OBJECT;
    }

    protected static ValueType getBasicObjectValueType(Class<?> type) {
        for (Class<?> c = type; c != null && c != Object.class; c = c.getSuperclass()) {
            ValueType valueType = _basicObjectValueTypeMap.get(c);
            if (valueType == null) continue;
            return valueType;
        }
        return null;
    }

    protected static ValueType getBasicInterfaceValueType(Class<?> type) {
        Set<Map.Entry<Class<?>, ValueType>> entrySet = _basicInterfaceValueTypeMap.entrySet();
        for (Map.Entry<Class<?>, ValueType> entry : entrySet) {
            Class<?> inf = entry.getKey();
            if (!inf.isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueType getValueType(int jdbcDefType) {
        Class<?> type = TnValueTypes.getType(jdbcDefType);
        if (type.equals(Object.class)) {
            ValueType valueType = _dynamicObjectValueTypeMap.get(jdbcDefType);
            if (valueType != null) {
                return valueType;
            }
            Map<Integer, ValueType> map = _dynamicObjectValueTypeMap;
            synchronized (map) {
                valueType = _dynamicObjectValueTypeMap.get(jdbcDefType);
                if (valueType != null) {
                    return valueType;
                }
                ObjectType objectType = new ObjectType(jdbcDefType);
                _dynamicObjectValueTypeMap.put(jdbcDefType, objectType);
                return objectType;
            }
        }
        return TnValueTypes.getValueType(type);
    }

    protected static Class<?> getType(int jdbcDefType) {
        switch (jdbcDefType) {
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTE_ARRAY_CLASS;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public static ValueType getPluginValueType(String valueTypeName) {
        TnValueTypes.assertObjectNotNull("valueTypeName", valueTypeName);
        return _pluginValueTypeMap.get(valueTypeName);
    }

    public static boolean isDefaultObject(ValueType valueType) {
        if (valueType == null) {
            return false;
        }
        if (!ObjectType.class.equals(valueType.getClass())) {
            return false;
        }
        return ((ObjectType)valueType).isDefaultObject();
    }

    public static boolean isDynamicObject(ValueType valueType) {
        if (valueType == null) {
            return false;
        }
        if (!ObjectType.class.equals(valueType.getClass())) {
            return false;
        }
        return !((ObjectType)valueType).isDefaultObject();
    }

    public static synchronized void registerBasicValueType(Class<?> keyType, ValueType valueType) {
        TnValueTypes.assertObjectNotNull("keyType", keyType);
        TnValueTypes.assertObjectNotNull("valueType", valueType);
        if (keyType.isInterface()) {
            _basicInterfaceValueTypeMap.put(keyType, valueType);
        } else {
            _basicObjectValueTypeMap.put(keyType, valueType);
        }
    }

    public static synchronized void removeBasicValueType(Class<?> keyType) {
        TnValueTypes.assertObjectNotNull("keyType", keyType);
        if (_basicObjectValueTypeMap.containsKey(keyType)) {
            _basicObjectValueTypeMap.remove(keyType);
        }
        if (_basicInterfaceValueTypeMap.containsKey(keyType)) {
            _basicInterfaceValueTypeMap.remove(keyType);
        }
    }

    public static synchronized void registerPluginValueType(String keyName, ValueType valueType) {
        TnValueTypes.assertObjectNotNull("keyName", keyName);
        TnValueTypes.assertObjectNotNull("valueType", valueType);
        _pluginValueTypeMap.put(keyName, valueType);
    }

    public static synchronized void removePluginValueType(String keyName) {
        TnValueTypes.assertObjectNotNull("keyName", keyName);
        _pluginValueTypeMap.remove(keyName);
    }

    protected static synchronized void restoreDefault() {
        _basicObjectValueTypeMap.clear();
        _basicInterfaceValueTypeMap.clear();
        _pluginValueTypeMap.clear();
        _dynamicObjectValueTypeMap.clear();
        TnValueTypes.initialize();
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        TnValueTypes.initialize();
    }
}

