/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;

public class BinaryType
extends TnAbstractValueType {
    public BinaryType() {
        super(-2);
    }

    public Object getValue(ResultSet rs, int index) throws SQLException {
        try {
            return this.toByteArray(rs.getBlob(index));
        }
        catch (SQLException ignored) {
            return rs.getBytes(index);
        }
    }

    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        try {
            return this.toByteArray(rs.getBlob(columnName));
        }
        catch (SQLException ignored) {
            return rs.getBytes(columnName);
        }
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        try {
            return this.toByteArray(cs.getBlob(index));
        }
        catch (SQLException ignored) {
            return cs.getBytes(index);
        }
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        try {
            return this.toByteArray(cs.getBlob(parameterName));
        }
        catch (SQLException ignored) {
            return cs.getBytes(parameterName);
        }
    }

    private byte[] toByteArray(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        long l = blob.length();
        if (Integer.MAX_VALUE < l) {
            String msg = "The length of the BLOB value should be less (equal) than integer:";
            msg = msg + " length=" + l + " value=" + blob;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        return blob.getBytes(1L, (int)l);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            ByteArrayInputStream in = new ByteArrayInputStream(ba);
            ps.setBinaryStream(index, (InputStream)in, ba.length);
        } else {
            ps.setObject(index, value);
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            ByteArrayInputStream in = new ByteArrayInputStream(ba);
            cs.setBinaryStream(parameterName, (InputStream)in, ba.length);
        } else {
            cs.setObject(parameterName, value);
        }
    }
}

