/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.util.DfTypeUtil;

public class DisplaySqlBuilder {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String NULL = "null";
    protected static final Class<?>[] TOTEXT_ARGUMENT_TYPES = new Class[]{Object.class};
    protected static final Method TOTEXT_METHOD;

    private DisplaySqlBuilder() {
    }

    public static String buildDisplaySql(String sql, Object[] args, String logDateFormat, String logTimestampFormat) {
        if (args == null || args.length == 0) {
            return sql;
        }
        return DisplaySqlBuilder.buildDisplaySql(sql, args, new ValueType[args.length], logDateFormat, logTimestampFormat);
    }

    public static String buildDisplaySql(String sql, Object[] args, ValueType[] valueTypes, String logDateFormat, String logTimestampFormat) {
        if (args == null || args.length == 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder(sql.length() + args.length * 15);
        int pos = 0;
        int pos2 = 0;
        int pos3 = 0;
        int pos4 = 0;
        int pos5 = 0;
        int pos6 = 0;
        int index = 0;
        while (true) {
            pos = sql.indexOf(63, pos2);
            pos3 = sql.indexOf(39, pos2);
            pos4 = sql.indexOf(39, pos3 + 1);
            pos5 = sql.indexOf("/*", pos2);
            pos6 = sql.indexOf("*/", pos5 + 1);
            if (pos <= 0) break;
            if (pos3 >= 0 && pos3 < pos && pos < pos4) {
                sb.append(sql.substring(pos2, pos4 + 1));
                pos2 = pos4 + 1;
                continue;
            }
            if (pos5 >= 0 && pos5 < pos && pos < pos6) {
                sb.append(sql.substring(pos2, pos6 + 1));
                pos2 = pos6 + 1;
                continue;
            }
            if (args.length <= index) {
                String msg = "The size of bind arguments is illegal:";
                msg = msg + " size=" + args.length + " sql=" + sql;
                throw new IllegalStateException(msg);
            }
            sb.append(sql.substring(pos2, pos));
            sb.append(DisplaySqlBuilder.getBindVariableText(args[index], valueTypes[index], logDateFormat, logTimestampFormat));
            pos2 = pos + 1;
            ++index;
        }
        sb.append(sql.substring(pos2));
        return sb.toString();
    }

    public static String getBindVariableText(Object bindVariable, ValueType valueType, String logDateFormat, String logTimestampFormat) {
        if (valueType != null && TOTEXT_METHOD != null) {
            try {
                return (String)TOTEXT_METHOD.invoke((Object)valueType, bindVariable);
            }
            catch (IllegalArgumentException e) {
                String msg = "ValueType.toText() threw the IllegalArgumentException:";
                msg = msg + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = "ValueType.toText() threw the IllegalAccessException:";
                msg = msg + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                String msg = "ValueType.toText() threw the exception:";
                msg = msg + " valueType=" + valueType + " bindVariable=" + bindVariable;
                throw new IllegalStateException(msg, e.getTargetException());
            }
        }
        return DisplaySqlBuilder.getBindVariableText(bindVariable, logDateFormat, logTimestampFormat);
    }

    public static String getBindVariableText(Object bindVariable, String logDateFormat, String logTimestampFormat) {
        if (bindVariable instanceof String) {
            return DisplaySqlBuilder.quote(bindVariable.toString());
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Timestamp) {
            return DisplaySqlBuilder.buildTimestampText(bindVariable, logTimestampFormat);
        }
        if (bindVariable instanceof Time) {
            return DisplaySqlBuilder.buildTimeText(bindVariable);
        }
        if (bindVariable instanceof Date) {
            return DisplaySqlBuilder.buildDateText(bindVariable, logDateFormat);
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return NULL;
        }
        return DisplaySqlBuilder.quote(bindVariable.toString());
    }

    protected static String buildTimestampText(Object bindVariable, String logTimestampFormat) {
        String format = logTimestampFormat != null ? logTimestampFormat : DEFAULT_TIMESTAMP_FORMAT;
        Date date = (Date)bindVariable;
        return DisplaySqlBuilder.processDateDisplay(date, format);
    }

    protected static String buildTimeText(Object bindVariable) {
        String format = DEFAULT_TIME_FORMAT;
        Date date = (Date)bindVariable;
        DateFormat df = DisplaySqlBuilder.createDateFormat(DEFAULT_TIME_FORMAT);
        return DisplaySqlBuilder.quote(df.format(date));
    }

    protected static String buildDateText(Object bindVariable, String logDateFormat) {
        String format = logDateFormat != null ? logDateFormat : DEFAULT_DATE_FORMAT;
        Date date = (Date)bindVariable;
        return DisplaySqlBuilder.processDateDisplay(date, format);
    }

    protected static String processDateDisplay(Date date, String format) {
        DateFormatResource resource = DisplaySqlBuilder.analyzeDateFormat(format);
        DateFormat df = DisplaySqlBuilder.createDateFormat(resource);
        String disp = df.format(date);
        if (DisplaySqlBuilder.isBCPrefixTarget(date, resource)) {
            disp = "BC" + disp;
        }
        return DisplaySqlBuilder.quote(disp, resource);
    }

    protected static boolean isBCPrefixTarget(Date date, DateFormatResource resource) {
        String format = resource.getFormat();
        return DfTypeUtil.isDateBC(date) && format.startsWith("yyyy") && !format.contains("G");
    }

    protected static DateFormat createDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    protected static DateFormat createDateFormat(DateFormatResource resource) {
        return new SimpleDateFormat(resource.getFormat());
    }

    protected static DateFormatResource analyzeDateFormat(String format) {
        String rear;
        int dfMarkEndIndex;
        DateFormatResource resource = new DateFormatResource();
        String dfMark = "$df:{";
        int dfMarkBeginIndex = format.indexOf("$df:{");
        if (dfMarkBeginIndex >= 0 && (dfMarkEndIndex = (rear = format.substring(dfMarkBeginIndex + "$df:{".length())).indexOf("}")) >= 0) {
            resource.setFormat(rear.substring(0, dfMarkEndIndex));
            resource.setPrefix(format.substring(0, dfMarkBeginIndex));
            resource.setSuffix(rear.substring(dfMarkEndIndex + "}".length()));
            return resource;
        }
        resource.setFormat(format);
        return resource;
    }

    protected static String quote(String text) {
        return "'" + text + "'";
    }

    protected static String quote(String text, DateFormatResource resource) {
        String suffix;
        String result = DisplaySqlBuilder.quote(text);
        String prefix = resource.getPrefix();
        if (prefix != null && prefix.trim().length() > 0) {
            result = prefix + result;
        }
        if ((suffix = resource.getSuffix()) != null && suffix.trim().length() > 0) {
            result = result + suffix;
        }
        return result;
    }

    static {
        Method method = null;
        try {
            method = ValueType.class.getMethod("toText", TOTEXT_ARGUMENT_TYPES);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        TOTEXT_METHOD = method;
    }

    protected static class DateFormatResource {
        protected String _format;
        protected String _prefix;
        protected String _suffix;

        protected DateFormatResource() {
        }

        public String getFormat() {
            return this._format;
        }

        public void setFormat(String format) {
            this._format = format;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public void setPrefix(String prefix) {
            this._prefix = prefix;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public void setSuffix(String suffix) {
            this._suffix = suffix;
        }
    }
}

