/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3v1Handler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LyricsHandler {
    boolean foundLyrics = false;
    String lyricsText = null;
    ID3v1Handler id3v1 = null;

    public LyricsHandler(InputStream stream, ContentHandler handler) throws IOException, SAXException, TikaException {
        this(LyricsHandler.getSuffix(stream, 10368));
    }

    protected LyricsHandler(byte[] tagData) throws IOException, SAXException, TikaException {
        if (tagData.length < 128) {
            return;
        }
        byte[] last128 = new byte[128];
        System.arraycopy(tagData, tagData.length - 128, last128, 0, 128);
        this.id3v1 = new ID3v1Handler(last128);
        if (tagData.length < 137) {
            return;
        }
        int lookat = tagData.length - 9;
        if (this.id3v1.found) {
            lookat -= 128;
        }
        if (tagData[lookat + 0] == 76 && tagData[lookat + 1] == 89 && tagData[lookat + 2] == 82 && tagData[lookat + 3] == 73 && tagData[lookat + 4] == 67 && tagData[lookat + 5] == 83 && tagData[lookat + 6] == 50 && tagData[lookat + 7] == 48 && tagData[lookat + 8] == 48) {
            int tagLen;
            this.foundLyrics = true;
            int length = Integer.parseInt(new String(tagData, lookat - 6, 6));
            String lyrics = new String(tagData, lookat - length + 5, length - 11, "ASCII");
            for (int pos = 0; pos < lyrics.length() - 9; pos += tagLen) {
                String tagName = lyrics.substring(pos, pos + 3);
                tagLen = Integer.parseInt(lyrics.substring(pos + 3, pos + 9));
                if (!tagName.equals("LYR")) continue;
                this.lyricsText = lyrics.substring(pos + 9, pos + 9 + tagLen);
            }
        }
    }

    public boolean hasID3v1() {
        return this.id3v1 != null && this.id3v1.found;
    }

    public boolean hasLyrics() {
        return this.lyricsText != null && this.lyricsText.length() > 0;
    }

    protected static byte[] getSuffix(InputStream stream, int length) throws IOException {
        byte[] buffer = new byte[2 * length];
        int bytesInBuffer = 0;
        int n = stream.read(buffer);
        while (n != -1) {
            if ((bytesInBuffer += n) == buffer.length) {
                System.arraycopy(buffer, bytesInBuffer - length, buffer, 0, length);
                bytesInBuffer = length;
            }
            n = stream.read(buffer, bytesInBuffer, buffer.length - bytesInBuffer);
        }
        if (bytesInBuffer < length) {
            length = bytesInBuffer;
        }
        byte[] result = new byte[length];
        System.arraycopy(buffer, bytesInBuffer - length, result, 0, length);
        return result;
    }
}

