/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.extractors;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.sax.BoilerpipeSAXInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ExtractorBase
implements BoilerpipeExtractor {
    public String getText(String html) throws BoilerpipeProcessingException {
        try {
            return this.getText(new BoilerpipeSAXInput(new InputSource(new StringReader(html))).getTextDocument());
        }
        catch (SAXException e) {
            throw new BoilerpipeProcessingException(e);
        }
    }

    public String getText(InputSource is) throws BoilerpipeProcessingException {
        try {
            return this.getText(new BoilerpipeSAXInput(is).getTextDocument());
        }
        catch (SAXException e) {
            throw new BoilerpipeProcessingException(e);
        }
    }

    public String getText(URL url) throws BoilerpipeProcessingException {
        try {
            URLConnection conn = url.openConnection();
            String encoding = conn.getContentEncoding();
            Charset cs = Charset.forName("Cp1252");
            if (encoding != null) {
                try {
                    cs = Charset.forName(encoding);
                }
                catch (UnsupportedCharsetException e) {
                    // empty catch block
                }
            }
            InputStream in = conn.getInputStream();
            InputSource is = new InputSource(in);
            if (cs != null) {
                is.setEncoding(cs.name());
            }
            String text = this.getText(is);
            in.close();
            return text;
        }
        catch (IOException e) {
            throw new BoilerpipeProcessingException(e);
        }
    }

    public String getText(Reader r) throws BoilerpipeProcessingException {
        return this.getText(new InputSource(r));
    }

    public String getText(TextDocument doc) throws BoilerpipeProcessingException {
        this.process(doc);
        return doc.getContent();
    }
}

