/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.gps.impl;

import org.mobylet.core.gps.Geo;
import org.mobylet.core.gps.GeoConverter;
import org.mobylet.core.gps.Gps;

public class MobyletEasyGeoConverter
implements GeoConverter {
    @Override
    public Gps toTokyo(Gps in) {
        if (in.getGeo() == Geo.WGS84) {
            Double lat = in.getLat() + 1.0696E-4 * in.getLat() - 1.7467E-5 * in.getLon() - 0.004602;
            Double lon = in.getLon() + 4.6047E-5 * in.getLat() + 8.3049E-5 * in.getLon() - 0.010041;
            Gps out = new Gps(lat, lon, Geo.TOKYO);
            out.setAccuracy(in.getAccuracy());
            return out;
        }
        return in;
    }

    @Override
    public Gps toWgs84(Gps in) {
        if (in.getGeo() == Geo.TOKYO) {
            Double lat = in.getLat() - 1.0695E-4 * in.getLat() + 1.7464E-5 * in.getLon() + 0.0046017;
            Double lon = in.getLon() - 4.6038E-5 * in.getLat() - 8.3043E-5 * in.getLon() + 0.01004;
            Gps out = new Gps(lat, lon, Geo.WGS84);
            out.setAccuracy(in.getAccuracy());
            return out;
        }
        return in;
    }
}

