/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image.impl;

import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.image.ImageClipRectangle;
import org.mobylet.core.image.ImageCodec;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ImageScaler;
import org.mobylet.core.image.ScaleType;
import org.mobylet.core.util.ImageUtils;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.SingletonUtils;

public class MobyletImageScaler
implements ImageScaler {
    protected boolean isHeadless = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scale(InputStream imgStream, OutputStream outStream, ImageCodec imageCodec, Integer newWidth, ScaleType scaleType) {
        try {
            BufferedImage img = ImageIO.read(imgStream);
            if (newWidth == null) {
                ImageConfig config = SingletonUtils.get(ImageConfig.class);
                String defWidth = null;
                defWidth = config.getDefaultScaleImageWidth();
                newWidth = defWidth != null ? Integer.valueOf(Integer.parseInt(defWidth)) : Integer.valueOf(img.getWidth());
            }
            ImageClipRectangle rectangle = this.getClipRectangle(img.getWidth(), img.getHeight(), newWidth, scaleType);
            int scaledWidth = rectangle.getWidth();
            int scaledHeight = rectangle.getHeight();
            if (scaleType == ScaleType.CLIPSQUARE) {
                scaledWidth = newWidth;
                scaledHeight = newWidth;
            }
            BufferedImage outImgBuf = null;
            if (img.getColorModel() instanceof IndexColorModel) {
                if (imageCodec == ImageCodec.GIF && img.getColorModel().hasAlpha()) {
                    if (!this.isHeadless) {
                        try {
                            outImgBuf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(scaledWidth, scaledHeight, 2);
                        }
                        catch (HeadlessException e) {
                            this.isHeadless = true;
                        }
                    }
                    if (this.isHeadless) {
                        outImgBuf = new BufferedImage(scaledWidth, scaledHeight, img.getType(), (IndexColorModel)img.getColorModel());
                        int transparentPixel = ((IndexColorModel)outImgBuf.getColorModel()).getTransparentPixel();
                        for (int i = 0; i < outImgBuf.getWidth(); ++i) {
                            for (int j = 0; j < outImgBuf.getHeight(); ++j) {
                                outImgBuf.setRGB(i, j, transparentPixel);
                            }
                        }
                    }
                } else {
                    outImgBuf = new BufferedImage(scaledWidth, scaledHeight, 2);
                }
            } else {
                outImgBuf = img.getType() == 0 ? new BufferedImage(scaledWidth, scaledHeight, 7) : new BufferedImage(scaledWidth, scaledHeight, img.getType());
            }
            if (scaleType == ScaleType.CLIPSQUARE) {
                boolean isLongWidth = img.getWidth() > img.getHeight();
                int clipWidth = isLongWidth ? img.getHeight() : img.getWidth();
                img = img.getSubimage(isLongWidth ? (img.getWidth() - clipWidth) / 2 : 0, isLongWidth ? 0 : (img.getHeight() - clipWidth) / 2, clipWidth, clipWidth);
            }
            Image scaledImg = img.getScaledInstance(scaledWidth, scaledHeight, 4);
            Graphics g = outImgBuf.getGraphics();
            try {
                g.drawImage(scaledImg, 0, 0, scaledWidth, scaledHeight, null);
            }
            finally {
                g.dispose();
            }
            boolean result = ImageIO.write((RenderedImage)outImgBuf, imageCodec.name(), outStream);
            if (!result) {
                throw new MobyletRuntimeException("\u753b\u50cf\u306e\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557", null);
            }
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("\u753b\u50cf\u5909\u63db\u4e2d\u306bIO\u4f8b\u5916\u304c\u767a\u751f", e);
        }
        finally {
            InputStreamUtils.closeQuietly(imgStream);
        }
    }

    @Override
    public ImageClipRectangle getClipRectangle(Integer width, Integer height, Integer newWidth, ScaleType scaleType) {
        return ImageUtils.getClipRectangle(width, height, newWidth, scaleType);
    }
}

