/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.bhv.outsidesql;

import java.util.List;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommand;
import org.seasar.robot.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.robot.dbflute.bhv.core.command.OutsideSqlSelectListCommand;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.cbean.FetchBean;
import org.seasar.robot.dbflute.exception.DangerousResultSizeException;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutsideSqlEntityExecutor<PARAMETER_BEAN> {
    protected final BehaviorCommandInvoker _behaviorCommandInvoker;
    protected final OutsideSqlOption _outsideSqlOption;
    protected final String _tableDbName;
    protected DBDef _currentDBDef;

    public OutsideSqlEntityExecutor(BehaviorCommandInvoker behaviorCommandInvoker, OutsideSqlOption outsideSqlOption, String tableDbName, DBDef currentDBDef) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
        this._outsideSqlOption = outsideSqlOption;
        this._tableDbName = tableDbName;
        this._currentDBDef = currentDBDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ENTITY> ENTITY selectEntity(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        List<ENTITY> ls;
        int preSafetyMaxResultSize = this.xcheckSafetyResultAsOneIfNeed(pmb);
        try {
            ls = this.invoke(this.createSelectListCommand(path, pmb, entityType));
        }
        catch (DangerousResultSizeException e) {
            String searchKey4Log = this.buildSearchKey4Log(path, pmb, entityType);
            this.throwEntityDuplicatedException("{over safetyMaxResultSize '1'}", searchKey4Log, e);
            ENTITY ENTITY = null;
            return ENTITY;
        }
        finally {
            this.xrestoreSafetyResultIfNeed(pmb, preSafetyMaxResultSize);
        }
        if (ls == null || ls.isEmpty()) {
            return null;
        }
        if (ls.size() > 1) {
            String searchKey4Log = this.buildSearchKey4Log(path, pmb, entityType);
            this.throwEntityDuplicatedException(String.valueOf(ls.size()), searchKey4Log, null);
        }
        return ls.get(0);
    }

    public <ENTITY> ENTITY selectEntityWithDeletedCheck(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        ENTITY entity = this.selectEntity(path, pmb, entityType);
        if (entity == null) {
            String searchKey4Log = this.buildSearchKey4Log(path, pmb, entityType);
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
        return entity;
    }

    protected <ENTITY> String buildSearchKey4Log(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        String tmp = "Table  = " + this._outsideSqlOption.getTableDbName() + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "Path   = " + path + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "Pmb    = " + (pmb != null ? pmb.getClass().getSimpleName() : "null") + ":" + pmb + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "Entity = " + (entityType != null ? entityType.getSimpleName() : "null") + OutsideSqlEntityExecutor.ln();
        tmp = tmp + "Option = " + this._outsideSqlOption;
        return tmp;
    }

    protected int xcheckSafetyResultAsOneIfNeed(PARAMETER_BEAN pmb) {
        if (pmb instanceof FetchBean) {
            int safetyMaxResultSize = ((FetchBean)pmb).getSafetyMaxResultSize();
            ((FetchBean)pmb).checkSafetyResult(1);
            return safetyMaxResultSize;
        }
        return 0;
    }

    protected void xrestoreSafetyResultIfNeed(PARAMETER_BEAN pmb, int preSafetyMaxResultSize) {
        if (pmb instanceof FetchBean) {
            ((FetchBean)pmb).checkSafetyResult(preSafetyMaxResultSize);
        }
    }

    protected void throwEntityAlreadyDeletedException(Object searchKey4Log) {
        ConditionBeanContext.throwEntityAlreadyDeletedException(searchKey4Log);
    }

    protected void throwEntityDuplicatedException(String resultCountString, Object searchKey4Log, Throwable cause) {
        ConditionBeanContext.throwEntityDuplicatedException(resultCountString, searchKey4Log, cause);
    }

    protected <ENTITY> BehaviorCommand<List<ENTITY>> createSelectListCommand(String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        return this.xsetupCommand(new OutsideSqlSelectListCommand(), path, pmb, entityType);
    }

    private <ENTITY> OutsideSqlSelectListCommand<ENTITY> xsetupCommand(OutsideSqlSelectListCommand<ENTITY> command, String path, PARAMETER_BEAN pmb, Class<ENTITY> entityType) {
        command.setTableDbName(this._tableDbName);
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setOutsideSqlPath(path);
        command.setParameterBean(pmb);
        command.setOutsideSqlOption(this._outsideSqlOption);
        command.setCurrentDBDef(this._currentDBDef);
        command.setEntityType(entityType);
        return command;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> configure(StatementConfig statementConfig) {
        this._outsideSqlOption.setStatementConfig(statementConfig);
        return this;
    }

    public OutsideSqlEntityExecutor<PARAMETER_BEAN> dynamicBinding() {
        this._outsideSqlOption.dynamicBinding();
        return this;
    }

    protected static String ln() {
        return DfSystemUtil.getLineSeparator();
    }
}

